/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.context;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.logger.DiagnosticContextValueProcessor;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.ThreadLocalProcessor;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationCollector;
import org.eclipse.scout.rt.server.clientnotification.IClientNodeId;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.logging.UserIdContextValueProvider;
import org.eclipse.scout.rt.shared.session.ScoutSessionIdContextValueProvider;
import org.eclipse.scout.rt.shared.ui.UserAgent;

public class ServerRunContext
extends RunContext {
    protected IServerSession m_session;
    protected UserAgent m_userAgent;
    protected String m_clientNodeId;
    protected ClientNotificationCollector m_clientNotificationCollector = new ClientNotificationCollector();

    protected <RESULT> void interceptCallableChain(CallableChain<RESULT> callableChain) {
        callableChain.add((ICallableDecorator)new ThreadLocalProcessor(ISession.CURRENT, (Object)this.m_session)).add((ICallableDecorator)new DiagnosticContextValueProcessor((DiagnosticContextValueProcessor.IDiagnosticContextValueProvider)BEANS.get(UserIdContextValueProvider.class))).add((ICallableDecorator)new DiagnosticContextValueProcessor((DiagnosticContextValueProcessor.IDiagnosticContextValueProvider)BEANS.get(ScoutSessionIdContextValueProvider.class))).add((ICallableDecorator)new ThreadLocalProcessor(UserAgent.CURRENT, (Object)this.m_userAgent)).add((ICallableDecorator)new ThreadLocalProcessor(IClientNodeId.CURRENT, (Object)this.m_clientNodeId)).add((ICallableDecorator)new ThreadLocalProcessor(ClientNotificationCollector.CURRENT, (Object)this.m_clientNotificationCollector));
    }

    public ServerRunContext withRunMonitor(RunMonitor runMonitor) {
        super.withRunMonitor(runMonitor);
        return this;
    }

    public ServerRunContext withSubject(Subject subject) {
        super.withSubject(subject);
        return this;
    }

    public ServerRunContext withLocale(Locale locale) {
        super.withLocale(locale);
        return this;
    }

    public ServerRunContext withCorrelationId(String correlationId) {
        super.withCorrelationId(correlationId);
        return this;
    }

    public ServerRunContext withTransactionScope(TransactionScope transactionScope) {
        super.withTransactionScope(transactionScope);
        return this;
    }

    public ServerRunContext withTransaction(ITransaction transaction) {
        super.withTransaction(transaction);
        return this;
    }

    public ServerRunContext withTransactionMember(ITransactionMember transactionMember) {
        super.withTransactionMember(transactionMember);
        return this;
    }

    public ServerRunContext withoutTransactionMembers() {
        super.withoutTransactionMembers();
        return this;
    }

    public <THREAD_LOCAL> ServerRunContext withThreadLocal(ThreadLocal<THREAD_LOCAL> threadLocal, THREAD_LOCAL value) {
        super.withThreadLocal(threadLocal, value);
        return this;
    }

    public ServerRunContext withDiagnostic(DiagnosticContextValueProcessor.IDiagnosticContextValueProvider provider) {
        super.withDiagnostic(provider);
        return this;
    }

    public ServerRunContext withDiagnostics(Collection<? extends DiagnosticContextValueProcessor.IDiagnosticContextValueProvider> diagnosticContextValueProviders) {
        super.withDiagnostics(diagnosticContextValueProviders);
        return this;
    }

    public ServerRunContext withProperty(Object key, Object value) {
        super.withProperty(key, value);
        return this;
    }

    public ServerRunContext withProperties(Map<?, ?> properties) {
        super.withProperties(properties);
        return this;
    }

    public IServerSession getSession() {
        return this.m_session;
    }

    public ServerRunContext withSession(IServerSession session) {
        this.m_session = session;
        return this;
    }

    public UserAgent getUserAgent() {
        return this.m_userAgent;
    }

    public ServerRunContext withUserAgent(UserAgent userAgent) {
        this.m_userAgent = userAgent;
        return this;
    }

    public String getClientNodeId() {
        return this.m_clientNodeId;
    }

    public ServerRunContext withClientNodeId(String clientNodeId) {
        this.m_clientNodeId = clientNodeId;
        return this;
    }

    public ClientNotificationCollector getClientNotificationCollector() {
        return this.m_clientNotificationCollector;
    }

    public ServerRunContext withClientNotificationCollector(ClientNotificationCollector collector) {
        this.m_clientNotificationCollector = collector;
        return this;
    }

    protected void interceptToStringBuilder(ToStringBuilder builder) {
        super.interceptToStringBuilder(builder.ref("session", (Object)this.getSession()).attr("userAgent", (Object)this.getUserAgent()).attr("clientNodeId", this.getClientNodeId()).ref("transactionalClientNotificationCollector", (Object)this.getClientNotificationCollector()));
    }

    protected void copyValues(RunContext runContext) {
        super.copyValues(runContext);
        ServerRunContext origin = (ServerRunContext)runContext;
        this.m_session = origin.m_session;
        this.m_userAgent = origin.m_userAgent;
        this.m_clientNotificationCollector = origin.m_clientNotificationCollector;
        this.m_clientNodeId = origin.m_clientNodeId;
    }

    protected void fillCurrentValues() {
        super.fillCurrentValues();
        this.m_userAgent = (UserAgent)UserAgent.CURRENT.get();
        this.m_session = ServerSessionProvider.currentSession();
        this.m_clientNotificationCollector = ClientNotificationCollector.CURRENT.get();
        this.m_clientNodeId = IClientNodeId.CURRENT.get();
    }

    public ServerRunContext copy() {
        ServerRunContext copy = (ServerRunContext)((Object)BEANS.get(ServerRunContext.class));
        copy.copyValues(this);
        return copy;
    }

    public <T> T getAdapter(Class<T> type) {
        if (ISession.class.isAssignableFrom(type)) {
            return (T)this.m_session;
        }
        return null;
    }
}

