/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.security.Permission;
import java.util.Map;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.security.ReadGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkData;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;

public abstract class AbstractBookmarkStorageService
implements IBookmarkStorageService {
    public BookmarkData getBookmarkData() {
        Object userId = this.getCurrentUserId();
        BookmarkData newData = this.readBookmarks(userId);
        if (this.processSpoolToInbox(newData.getUserBookmarks())) {
            this.writeUserFolder(newData.getUserBookmarks(), userId);
        }
        return newData;
    }

    public BookmarkData storeBookmarkData(BookmarkData newData) {
        BookmarkFolder existingSpoolFolder;
        Object userId = this.getCurrentUserId();
        BookmarkFolder existingUserFolder = this.readUserFolder(userId);
        if (existingUserFolder != null && (existingSpoolFolder = existingUserFolder.getFolder("[SPOOL]")) != null) {
            newData.getUserBookmarks().getFolders().add(existingSpoolFolder);
            this.processSpoolToInbox(newData.getUserBookmarks());
        }
        this.writeBookmarks(newData, userId);
        return this.readBookmarks(userId);
    }

    private boolean processSpoolToInbox(BookmarkFolder folder) {
        BookmarkFolder spoolFolder;
        if (folder != null && (spoolFolder = folder.getFolder("[SPOOL]")) != null) {
            BookmarkFolder inboxFolder = folder.getFolder("[INBOX]");
            if (inboxFolder == null) {
                inboxFolder = new BookmarkFolder();
                inboxFolder.setTitle("[INBOX]");
                folder.getFolders().add(0, inboxFolder);
            }
            inboxFolder.addBookmarks(spoolFolder, true, false);
            folder.getFolders().remove(spoolFolder);
            return true;
        }
        return false;
    }

    public void publishBookmarkData(BookmarkFolder publishFolder, Map<String, Object> targetGroup) {
    }

    protected abstract Object getCurrentUserId();

    protected void publishBookmarkDataToUser(BookmarkFolder publishFolder, Object userId) {
        if (userId != null) {
            BookmarkFolder userSpool;
            BookmarkFolder userFolder = this.readUserFolder(userId);
            if (userFolder == null) {
                userFolder = new BookmarkFolder();
            }
            if ((userSpool = userFolder.getFolder("[SPOOL]")) == null) {
                userSpool = new BookmarkFolder();
                userSpool.setTitle("[SPOOL]");
                userFolder.getFolders().add(0, userSpool);
            }
            userSpool.addBookmarks(publishFolder, true, false);
            this.writeUserFolder(userFolder, userId);
        }
    }

    protected BookmarkData readBookmarks(Object userId) {
        BookmarkData model = new BookmarkData();
        BookmarkFolder folder = this.readUserFolder(userId);
        if (folder != null) {
            model.setUserBookmarks(folder);
        }
        if (ACCESS.check((Permission)new ReadGlobalBookmarkPermission()) && (folder = this.readGlobalFolder()) != null) {
            model.setGlobalBookmarks(folder);
        }
        return model;
    }

    protected void writeBookmarks(BookmarkData model, Object userId) {
        if (ACCESS.check((Permission)new UpdateUserBookmarkPermission())) {
            this.writeUserFolder(model.getUserBookmarks(), userId);
        }
        if (ACCESS.check((Permission)new UpdateGlobalBookmarkPermission())) {
            this.writeGlobalFolder(model.getGlobalBookmarks());
        }
    }

    protected abstract BookmarkFolder readUserFolder(Object var1);

    protected abstract BookmarkFolder readGlobalFolder();

    protected abstract void writeUserFolder(BookmarkFolder var1, Object var2);

    protected abstract void writeGlobalFolder(BookmarkFolder var1);
}

