/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.calendar;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.shared.services.common.calendar.HolidayCalendarItemParser;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.IHolidayCalendarService;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolidayCalendarService
implements IHolidayCalendarService {
    private static final Logger LOG = LoggerFactory.getLogger(HolidayCalendarService.class);
    private final ConcurrentExpiringMap<String, HolidayCalendarItemParser> m_holidayXmlCache = new ConcurrentExpiringMap(5L, TimeUnit.MINUTES);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends ICalendarItem> getItems(RemoteFile spec, Date minDate, Date maxDate) {
        HolidayCalendarItemParser p = null;
        String key = spec.getPath();
        ConcurrentExpiringMap<String, HolidayCalendarItemParser> concurrentExpiringMap = this.m_holidayXmlCache;
        synchronized (concurrentExpiringMap) {
            p = (HolidayCalendarItemParser)this.m_holidayXmlCache.get((Object)key);
            if (p == null) {
                try {
                    RemoteFile f = ((IRemoteFileService)BEANS.get(IRemoteFileService.class)).getRemoteFile(spec);
                    if (f != null) {
                        p = new HolidayCalendarItemParser(f.getDecompressedInputStream(), spec.getPath());
                        this.m_holidayXmlCache.put((Object)key, (Object)p);
                    }
                }
                catch (Exception e) {
                    LOG.warn("parsing remote file: {}", (Object)spec, (Object)e);
                }
            }
        }
        Set result = p != null ? p.getItems(NlsLocale.get(), minDate, maxDate) : CollectionUtility.hashSet((Object[])new ICalendarItem[0]);
        return result;
    }
}

