/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.util.Date;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;

public class ClusterNodeStatusInfo {
    private final ClusterNodeStatusBean m_info = new ClusterNodeStatusBean();
    private final Object m_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClusterNodeStatusInfo getStatus() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_info.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSentStatus(IClusterNotificationMessage sentMessage) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incSentMessageCount();
            this.updateLastChanged(sentMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReceiveStatus(IClusterNotificationMessage receivedMessage) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.incReceivedMessageCount();
            this.updateLastChanged(receivedMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastChanged(String userId, String originNode) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_info.setLastChangedDate(new Date());
            this.m_info.setLastChangedUserId(userId);
            this.m_info.setLastChangedOriginNodeId(originNode);
        }
    }

    private void updateLastChanged(IClusterNotificationMessage message) {
        this.updateLastChanged(message.getProperties().getOriginUser(), message.getProperties().getOriginNode());
    }

    private static class ClusterNodeStatusBean
    implements IClusterNodeStatusInfo {
        private long m_sentMessageCount;
        private long m_receivedMessageCount;
        private Date m_lastChangedDate;
        private String m_lastChangedUserId;
        private String m_lastChangedOriginNodeId;

        public ClusterNodeStatusBean() {
        }

        protected ClusterNodeStatusBean(ClusterNodeStatusBean other) {
            this.m_sentMessageCount = other.m_sentMessageCount;
            this.m_receivedMessageCount = other.m_receivedMessageCount;
            this.m_lastChangedDate = other.m_lastChangedDate;
            this.m_lastChangedUserId = other.m_lastChangedUserId;
            this.m_lastChangedOriginNodeId = other.m_lastChangedOriginNodeId;
        }

        @Override
        public long getSentMessageCount() {
            return this.m_sentMessageCount;
        }

        public void incSentMessageCount() {
            ++this.m_sentMessageCount;
        }

        @Override
        public long getReceivedMessageCount() {
            return this.m_receivedMessageCount;
        }

        public void incReceivedMessageCount() {
            ++this.m_receivedMessageCount;
        }

        @Override
        public Date getLastChangedDate() {
            return this.m_lastChangedDate;
        }

        public void setLastChangedDate(Date lastChangedDate) {
            this.m_lastChangedDate = lastChangedDate;
        }

        @Override
        public String getLastChangedUserId() {
            return this.m_lastChangedUserId;
        }

        public void setLastChangedUserId(String lastChangedUserId) {
            this.m_lastChangedUserId = lastChangedUserId;
        }

        @Override
        public String getLastChangedOriginNodeId() {
            return this.m_lastChangedOriginNodeId;
        }

        public void setLastChangedOriginNodeId(String lastChangedOriginNodeId) {
            this.m_lastChangedOriginNodeId = lastChangedOriginNodeId;
        }

        public ClusterNodeStatusBean copy() {
            return new ClusterNodeStatusBean(this);
        }

        public String toString() {
            return "ClusterNodeStatusBean [sentMessageCount=" + this.m_sentMessageCount + ", receivedMessageCount=" + this.m_receivedMessageCount + ", lastChangedDate=" + this.m_lastChangedDate + ", lastChangedUserId=" + this.m_lastChangedUserId + ", lastChangedOriginNodeId=" + this.m_lastChangedOriginNodeId + "]";
        }
    }
}

