/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.notification.NotificationCoalescer;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationProperties;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessage;

@ApplicationScoped
public class ClusterNotificationMessageCoalescer {
    public List<IClusterNotificationMessage> coalesce(List<IClusterNotificationMessage> inNotifications) {
        ArrayList<IClusterNotificationMessage> result = new ArrayList<IClusterNotificationMessage>();
        HashMap<IClusterNotificationProperties, List> notificationsPerProps = new HashMap<IClusterNotificationProperties, List>();
        for (IClusterNotificationMessage iClusterNotificationMessage : inNotifications) {
            List messages = notificationsPerProps.computeIfAbsent(iClusterNotificationMessage.getProperties(), k -> new ArrayList());
            messages.add(iClusterNotificationMessage.getNotification());
        }
        for (Map.Entry entry : notificationsPerProps.entrySet()) {
            result.addAll(this.coalesce((IClusterNotificationProperties)entry.getKey(), (List)entry.getValue()));
        }
        return result;
    }

    protected List<IClusterNotificationMessage> coalesce(IClusterNotificationProperties props, List<Serializable> notificationsIn) {
        if (notificationsIn.isEmpty()) {
            return new ArrayList<IClusterNotificationMessage>();
        }
        if (notificationsIn.size() == 1) {
            ClusterNotificationMessage message = new ClusterNotificationMessage((Serializable)CollectionUtility.firstElement(notificationsIn), props);
            return CollectionUtility.arrayList((Object)message);
        }
        List<Serializable> outNotifications = ((NotificationCoalescer)BEANS.get(NotificationCoalescer.class)).coalesce(notificationsIn);
        ArrayList<IClusterNotificationMessage> result = new ArrayList<IClusterNotificationMessage>();
        for (Serializable n : outNotifications) {
            result.add(new ClusterNotificationMessage(n, props));
        }
        return result;
    }
}

