/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.pwd;

import org.eclipse.scout.rt.server.services.common.pwd.DefaultPasswordPolicy;
import org.eclipse.scout.rt.server.services.common.pwd.IPasswordPolicy;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;

public abstract class AbstractPasswordManagementService
implements IPasswordManagementService {
    private IPasswordPolicy m_passwordPolicy;

    public AbstractPasswordManagementService() {
        this.setPasswordPolicy(new DefaultPasswordPolicy());
    }

    public void changePassword(String userId, char[] oldPassword, char[] newPassword) {
        this.checkAccess(userId, oldPassword);
        this.resetPassword(userId, newPassword);
    }

    public void resetPassword(String userId, char[] newPassword) {
        this.getPasswordPolicy().check(userId, newPassword, this.getUsernameFor(userId), this.getHistoryIndexFor(userId, newPassword));
        this.resetPasswordInternal(userId, newPassword);
    }

    public String getPasswordPolicyText() {
        return this.getPasswordPolicy().getText();
    }

    protected IPasswordPolicy getPasswordPolicy() {
        return this.m_passwordPolicy;
    }

    protected void setPasswordPolicy(IPasswordPolicy p) {
        this.m_passwordPolicy = p;
    }

    protected abstract void checkAccess(String var1, char[] var2);

    protected abstract String getUsernameFor(String var1);

    protected abstract int getHistoryIndexFor(String var1, char[] var2);

    protected abstract void resetPasswordInternal(String var1, char[] var2);
}

