/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.pwd;

import java.util.Arrays;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.server.services.common.pwd.IPasswordPolicy;

public class DefaultPasswordPolicy
implements IPasswordPolicy {
    private static final int MIN_PASSWORD_LENGTH = 8;

    @Override
    public String getText() {
        return TEXTS.get((String)"DefaultPasswordPolicyText");
    }

    @Override
    public void check(String userId, char[] newPassword, String userName, int historyIndex) {
        if (newPassword == null || newPassword.length < 8) {
            throw new VetoException(TEXTS.get((String)"PasswordMin8Chars"), new Object[0]);
        }
        if (historyIndex >= 0) {
            throw new VetoException(TEXTS.get((String)"PasswordNotSameAsLasts"), new Object[0]);
        }
        char[] charsInPasswordSorted = Arrays.copyOf(newPassword, newPassword.length);
        Arrays.sort(charsInPasswordSorted);
        if (!DefaultPasswordPolicy.containsOneOf(charsInPasswordSorted, "0123456789")) {
            throw new VetoException(TEXTS.get((String)"PasswordMinOneDigit"), new Object[0]);
        }
        if (!DefaultPasswordPolicy.containsOneOf(charsInPasswordSorted, "abcdefghijklmnopqrstuvwxyz")) {
            throw new VetoException(TEXTS.get((String)"PasswordMinOneChar", (String[])new String[]{"a-z"}), new Object[0]);
        }
        if (!DefaultPasswordPolicy.containsOneOf(charsInPasswordSorted, "ABCDEFGHIJKLMNOPQRSTUVWXYZ")) {
            throw new VetoException(TEXTS.get((String)"PasswordMinOneChar", (String[])new String[]{"A-Z"}), new Object[0]);
        }
        if (!DefaultPasswordPolicy.containsOneOf(charsInPasswordSorted, "!@#$%^&*()_+|~-=\\`{}[]:\";'<>?,./")) {
            throw new VetoException(TEXTS.get((String)"PasswordMinOnNonStdChar"), new Object[0]);
        }
        if (DefaultPasswordPolicy.containsUsername(newPassword, userName)) {
            throw new VetoException(TEXTS.get((String)"PasswordUsernameNotPartOfPass"), new Object[0]);
        }
    }

    private static boolean containsUsername(char[] newPassword, String userName) {
        if (userName == null) {
            return false;
        }
        StringBuilder b = new StringBuilder(newPassword.length);
        char[] cArray = newPassword;
        int n = newPassword.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            b.append(Character.toUpperCase(c));
            ++n2;
        }
        return b.indexOf(userName.toUpperCase()) >= 0;
    }

    private static boolean containsOneOf(char[] charsOfPasswordSorted, String charsToSearch) {
        char[] cArray = charsToSearch.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char toFind = cArray[n2];
            if (Arrays.binarySearch(charsOfPasswordSorted, toFind) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

