/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.server.commons.servlet.IHttpServletRoundtrip;
import org.eclipse.scout.rt.shared.services.common.security.ILogoutService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutService
implements ILogoutService {
    private static final Logger LOG = LoggerFactory.getLogger(LogoutService.class);

    public void logout() {
        ((IAccessControlService)BEANS.get(IAccessControlService.class)).clearCacheOfCurrentUser();
        HttpServletRequest httpRequest = (HttpServletRequest)IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST.get();
        if (httpRequest != null) {
            try {
                HttpSession session = httpRequest.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
            }
            catch (IllegalStateException e) {
                LOG.debug("Tried to invalidate an already invalidated session.", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Failed to invalidate HTTP session.", (Throwable)e);
            }
        }
    }
}

