/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=4900.0)
public class PermissionService
implements IPermissionService {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionService.class);
    private final Object m_permissionClassesLock = new Object();
    private Set<Class<? extends Permission>> m_permissionClasses;

    public Set<Class<? extends Permission>> getAllPermissionClasses() {
        this.checkCache();
        return CollectionUtility.hashSet(this.m_permissionClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache() {
        Object object = this.m_permissionClassesLock;
        synchronized (object) {
            if (this.m_permissionClasses == null) {
                Set<IClassInfo> allKnownPermissions = this.getPermissionsFromInventory();
                HashSet<Class> discoveredPermissions = new HashSet<Class>(allKnownPermissions.size());
                for (IClassInfo permInfo : allKnownPermissions) {
                    if (!this.acceptClass(permInfo)) continue;
                    try {
                        Class permClass = permInfo.resolveClass();
                        discoveredPermissions.add(permClass);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to load permission.", (Throwable)e);
                    }
                }
                this.m_permissionClasses = CollectionUtility.hashSet(discoveredPermissions);
            }
        }
    }

    protected Set<IClassInfo> getPermissionsFromInventory() {
        IClassInventory inv = ClassInventory.get();
        Set classes = inv.getAllKnownSubClasses(Permission.class);
        classes.addAll(inv.getAllKnownSubClasses(BasicPermission.class));
        return classes;
    }

    protected boolean acceptClass(IClassInfo permInfo) {
        return permInfo.isInstanciable() && this.acceptClassName(permInfo.name());
    }

    protected boolean acceptClassName(String className) {
        return true;
    }
}

