/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.ObjectName;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.context.PlatformIdentifier;
import org.eclipse.scout.rt.platform.jmx.MBeanUtility;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.session.IServerSessionCacheMBean;
import org.eclipse.scout.rt.server.session.ServerSessionCache;
import org.eclipse.scout.rt.server.session.ServerSessionEntry;

@ApplicationScoped
@CreateImmediately
public class ServerSessionCacheMBean
implements IServerSessionCacheMBean {
    @PostConstruct
    protected void register() {
        MBeanUtility.register((ObjectName)this.jmxObjectName(), (Object)this);
    }

    @PreDestroy
    protected void unregister() {
        MBeanUtility.unregister((ObjectName)this.jmxObjectName());
    }

    protected ObjectName jmxObjectName() {
        return MBeanUtility.toJmxName((String)"org.eclipse.scout.rt.server", (String)PlatformIdentifier.get(), (String)ServerSessionCache.class.getSimpleName());
    }

    @Override
    public int getCacheSize() {
        return this.getCache().size();
    }

    @Override
    public int getNumLockedRootLocks() {
        return this.getCache().numLockedRootLocks();
    }

    @Override
    public int getNumRootLocks() {
        return this.getCache().numRootLocks();
    }

    protected ServerSessionCache getCache() {
        return (ServerSessionCache)BEANS.get(ServerSessionCache.class);
    }

    @Override
    public IServerSessionCacheMBean.ServerSessionCacheEntry[] getEntries() {
        return (IServerSessionCacheMBean.ServerSessionCacheEntry[])this.getCache().cacheMap().entrySet().stream().map(this::toServerSessionCacheEntry).toArray(IServerSessionCacheMBean.ServerSessionCacheEntry[]::new);
    }

    protected IServerSessionCacheMBean.ServerSessionCacheEntry toServerSessionCacheEntry(Map.Entry<String, ServerSessionEntry> mapEntry) {
        ServerSessionEntry entry = mapEntry.getValue();
        return new IServerSessionCacheMBean.ServerSessionCacheEntry(mapEntry.getKey(), entry.httpSessionCount(), this.getServerSessionStatus(entry));
    }

    protected String getServerSessionStatus(ServerSessionEntry entry) {
        IServerSession scoutSession = entry.getScoutSession();
        if (scoutSession == null) {
            return "no session created";
        }
        if (scoutSession.isActive()) {
            return "started";
        }
        if (scoutSession.isStopping()) {
            return "stopping";
        }
        return "stopped";
    }
}

