/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.session.IServerSessionLifecycleHandler;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionLifecycleHandler
implements IServerSessionLifecycleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSessionLifecycleHandler.class);
    private final String m_scoutSessionId;
    private final String m_clientNodeId;
    private final ServerRunContext m_serverRunContextForSessionStart;

    public ServerSessionLifecycleHandler(String scoutSessionId, ServerRunContext serverRunContextForSessionStart) {
        this.m_scoutSessionId = Assertions.assertNotNullOrEmpty((String)scoutSessionId, (String)"sessionId must not be null or empty", (Object[])new Object[0]);
        this.m_serverRunContextForSessionStart = (ServerRunContext)((Object)Assertions.assertNotNull((Object)((Object)serverRunContextForSessionStart), (String)"serverRunContext must not be null", (Object[])new Object[0]));
        this.m_clientNodeId = serverRunContextForSessionStart.getClientNodeId();
    }

    @Override
    public String getId() {
        return this.m_scoutSessionId;
    }

    @Override
    public IServerSession create() {
        LOG.debug("Creating scout server session with scoutSessionId={}", (Object)this.getId());
        Object session = ((ServerSessionProvider)BEANS.get(ServerSessionProvider.class)).opt(this.getId(), this.m_serverRunContextForSessionStart);
        if (session == null) {
            return null;
        }
        Assertions.assertEqual((Comparable)((Object)session.getId()), (Comparable)((Object)this.getId()));
        if (this.m_clientNodeId != null) {
            ((IClientNotificationService)BEANS.get(IClientNotificationService.class)).registerSession(this.m_clientNodeId, session.getId(), session.getUserId());
        }
        return session;
    }

    @Override
    public void destroy(IServerSession session) {
        LOG.debug("Destroying scout server scoutSessionId={}", (Object)session.getId());
        try {
            session.stop();
        }
        finally {
            if (this.m_clientNodeId != null) {
                ((IClientNotificationService)BEANS.get(IClientNotificationService.class)).unregisterSession(this.m_clientNodeId, session.getId(), session.getUserId());
            }
        }
    }
}

