/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared;

import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.Replace;
import org.eclipse.scout.rt.shared.TunnelToServer;
import org.eclipse.scout.rt.testing.platform.BeanTestingHelper;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Replace
public class SharedBeanTestingHelper
extends BeanTestingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SharedBeanTestingHelper.class);

    protected void interceptRegisterBean(BeanMetaData beanData) {
        super.interceptRegisterBean(beanData);
        if (Mockito.mockingDetails((Object)beanData.getInitialInstance()).isMock() && beanData.getBeanAnnotation(TunnelToServer.class) != null) {
            LOG.info("removing TunnelToServer annotation on mocked bean: {}", (Object)beanData.getBeanClazz());
            beanData.withoutAnnotation(TunnelToServer.class);
        }
    }
}

