/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared;

import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.SleepUtil;
import org.junit.Assert;

public final class TestingUtility {
    private TestingUtility() {
    }

    public static String createLocaleSpecificNumberString(Locale loc, boolean minus, String integerPart, String fractionPart) {
        return TestingUtility.createLocaleSpecificNumberString(loc, minus, integerPart, fractionPart, NumberStringPercentSuffix.NONE);
    }

    public static String createLocaleSpecificNumberString(Locale loc, boolean minus, String integerPart) {
        return TestingUtility.createLocaleSpecificNumberString(loc, minus, integerPart, null, NumberStringPercentSuffix.NONE);
    }

    public static String createLocaleSpecificNumberString(Locale loc, boolean minus, String integerPart, String fractionPart, NumberStringPercentSuffix percentSuffix) {
        String suffix;
        byte[] suffixBytes;
        DecimalFormatSymbols symbols = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(loc).getDecimalFormatSymbols();
        StringBuilder sb = new StringBuilder();
        if (minus) {
            sb.append(symbols.getMinusSign());
        }
        sb.append(integerPart);
        if (fractionPart != null) {
            sb.append(symbols.getDecimalSeparator()).append(fractionPart);
        }
        if ((suffixBytes = (suffix = percentSuffix.getSuffix(symbols)).getBytes(StandardCharsets.UTF_16BE)).length == 2 && suffixBytes[0] == 32 && suffixBytes[1] == 14) {
            return sb.append('%').toString();
        }
        return sb.append(suffix).toString();
    }

    public static void assertGC(WeakReference<?> ref) {
        int maxRuns = 50;
        int i = 0;
        while (i < maxRuns) {
            if (ref.get() == null) {
                return;
            }
            System.gc();
            SleepUtil.sleepSafe((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            ++i;
        }
        Assert.fail((String)("Potential memory leak, object " + ref.get() + "still exists after gc"));
    }

    public static enum NumberStringPercentSuffix {
        NONE{

            @Override
            public String getSuffix(DecimalFormatSymbols symbols) {
                return "";
            }
        }
        ,
        JUST_SYMBOL{

            @Override
            public String getSuffix(DecimalFormatSymbols symbols) {
                return String.valueOf(symbols.getPercent());
            }
        }
        ,
        BLANK_AND_SYMBOL{

            @Override
            public String getSuffix(DecimalFormatSymbols symbols) {
                return " " + symbols.getPercent();
            }
        };


        public abstract String getSuffix(DecimalFormatSymbols var1);
    }
}

