/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared.services.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;

public class TestingLookupService
implements ILookupService<Long> {
    private List<ILookupRow<Long>> m_rows = new ArrayList<ILookupRow<Long>>();

    public List<ILookupRow<Long>> getRows() {
        return CollectionUtility.arrayList(this.m_rows);
    }

    public void setRows(List<ILookupRow<Long>> rows) {
        this.m_rows = CollectionUtility.arrayList(rows);
    }

    public List<ILookupRow<Long>> getDataByKey(ILookupCall<Long> call) {
        ArrayList<ILookupRow<Long>> list = new ArrayList<ILookupRow<Long>>();
        Object key = call.getKey();
        if (key != null) {
            for (ILookupRow<Long> row : this.getRows()) {
                if (!key.equals(row.getKey())) continue;
                list.add(row);
            }
        }
        return list;
    }

    public List<ILookupRow<Long>> getDataByRec(ILookupCall<Long> call) {
        ArrayList<ILookupRow<Long>> list = new ArrayList<ILookupRow<Long>>();
        Object parentKey = call.getRec();
        if (parentKey == null) {
            for (ILookupRow<Long> row : this.getRows()) {
                if (row.getParentKey() != null) continue;
                list.add(row);
            }
        } else {
            for (ILookupRow<Long> row : this.getRows()) {
                if (row.getParentKey() != parentKey) continue;
                list.add(row);
            }
        }
        return list;
    }

    public List<ILookupRow<Long>> getDataByText(ILookupCall<Long> call) {
        ArrayList<ILookupRow<Long>> list = new ArrayList<ILookupRow<Long>>();
        Pattern p = TestingLookupService.createLowerCaseSearchPattern(call.getText());
        for (ILookupRow<Long> row : this.getRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list;
    }

    public List<ILookupRow<Long>> getDataByAll(ILookupCall<Long> call) {
        ArrayList<ILookupRow<Long>> list = new ArrayList<ILookupRow<Long>>();
        Pattern p = TestingLookupService.createLowerCaseSearchPattern(call.getAll());
        for (ILookupRow<Long> row : this.getRows()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list;
    }

    public static Pattern createLowerCaseSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if ((s = s.toLowerCase()).indexOf(42) < 0) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }
}

