/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared;

import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.AbstractBinaryConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractSubjectConfigProperty;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.TunnelToServer;
import org.eclipse.scout.rt.shared.services.common.text.dev.TextKeyTextProviderService;

public final class SharedConfigProperties {
    private SharedConfigProperties() {
    }

    public static class AuthTokenPrivateKeyProperty
    extends AbstractBinaryConfigProperty {
        public String getKey() {
            return "scout.auth.privateKey";
        }

        public String description() {
            return String.format("Specifies the Base64 encoded private key for signing requests from the UI server to the backend server. By validating the signature the server can ensure the request is trustworthy.\nFurthermore the CookieAccessController uses this private key to sign the cookie.\nNew public-private-key-pairs can be created by invoking the class '%s' on the command line.", SecurityUtility.class.getName());
        }
    }

    public static class AuthTokenPublicKeyProperty
    extends AbstractBinaryConfigProperty {
        public String getKey() {
            return "scout.auth.publicKey";
        }

        public String description() {
            return String.format("Specifies the Base64 encoded public key used to validate signed requests on the backend server. The public key must match the private key stored in the property '%s' on the UI server.\nNew public-private-key-pairs can be created by invoking the class '%s' on the command line.", ((AuthTokenPrivateKeyProperty)((Object)BEANS.get(AuthTokenPrivateKeyProperty.class))).getKey(), SecurityUtility.class.getName());
        }
    }

    public static class AuthTokenTimeToLiveProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.MINUTES.toMillis(10L);
        }

        public String description() {
            return "Number of milliseconds a signature on a request from the UI server to the backend server is valid (TTL for the authentication token). If a request is not received within this time, it is rejected.\nBy default this property is set to 10 minutes.";
        }

        public String getKey() {
            return "scout.auth.tokenTtl";
        }
    }

    public static class BackendUrlProperty
    extends AbstractStringConfigProperty {
        public String getDefaultValue() {
            return ConfigUtility.getProperty((String)"server.url");
        }

        public String getKey() {
            return "scout.backendUrl";
        }

        public String description() {
            return "The URL of the scout backend server (without any servlets). E.g.: http://localhost:8080\nBy default this property is null.";
        }

        protected String parse(String value) {
            if (value == null) {
                return null;
            }
            int i = value.lastIndexOf("/process");
            if (i >= 0) {
                value = value.substring(0, i);
            }
            return super.parse(value);
        }
    }

    public static class CompressServiceTunnelRequestProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return null;
        }

        public String description() {
            return "Specifies if the service tunnel should compress the data. If null, the response decides which is default to true.";
        }

        public String getKey() {
            return "scout.servicetunnel.compress";
        }
    }

    public static class CreateTunnelToServerBeansProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.createTunnelToServerBeans";
        }

        public String description() {
            return String.format("Specifies if the Scout platform should create proxy beans for interfaces annotated with '%s'. Calls to beans of such types are then tunneled to the Scout backend.\nBy default this property is enabled if the property '%s' is set.", TunnelToServer.class.getSimpleName(), ((ServiceTunnelTargetUrlProperty)((Object)BEANS.get(ServiceTunnelTargetUrlProperty.class))).getKey());
        }

        public Boolean getDefaultValue() {
            return StringUtility.hasText((CharSequence)((CharSequence)((ServiceTunnelTargetUrlProperty)((Object)BEANS.get(ServiceTunnelTargetUrlProperty.class))).getValue()));
        }
    }

    public static class DevTextProvidersShowKeysProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.texts.showKeys";
        }

        public String description() {
            return String.format("If this property is set to true, the '%s' will be registered with high priority, and each call to %s.get() will return the given text key instead of the translation.\nThis is useful for debug/testing purposes or exporting forms to JSON.\nBy default this property is false.", TextKeyTextProviderService.class.getSimpleName(), TEXTS.class.getSimpleName());
        }

        public Boolean getDefaultValue() {
            return false;
        }
    }

    public static class ExternalBaseUrlProperty
    extends AbstractStringConfigProperty {
        public String getKey() {
            return "scout.externalBaseUrl";
        }

        public String description() {
            return "Absolute URL to the deployed http(s):// base of the web-application. The URL should include proxies, redirects, etc.\nExample: https://www.my-company.com/my-scout-application/.\nThis URL is used to replace '<scout:base />' tags.";
        }

        protected String parse(String value) {
            if (StringUtility.hasText((CharSequence)value)) {
                if (!value.endsWith("/")) {
                    value = String.valueOf(value) + "/";
                }
                return value;
            }
            return null;
        }
    }

    public static class LoadWebResourcesFromFilesystemConfigProperty
    extends AbstractBooleanConfigProperty {
        public Boolean getDefaultValue() {
            return Platform.get().inDevelopmentMode();
        }

        public String getKey() {
            return "scout.loadWebResourcesFromFilesystem";
        }

        public String description() {
            return "Specifies if the application should look for web resources (like .js, .html or .css) on the local filesystem. If true, the resources will be searched in modules that follow the Scout naming conventions (e.g. name.ui.app.dev, name.ui.app, name.ui) on the local filesystem first and (if not found) on the classpath second. If false, the resources are searched on the Java classpath only. By default this property is true in dev mode and false otherwise.";
        }
    }

    public static class NotificationSubjectProperty
    extends AbstractSubjectConfigProperty {
        public static final String NOTIFICATION_AUTHENTICATOR_SUBJECT_NAME = "notification-authenticator";

        public String getKey() {
            return "scout.client.notificationSubject";
        }

        public String description() {
            return String.format("Technical subject under which received client notifications are executed.\nBy default '%s' is used.", NOTIFICATION_AUTHENTICATOR_SUBJECT_NAME);
        }

        public Subject getDefaultValue() {
            return this.convertToSubject(NOTIFICATION_AUTHENTICATOR_SUBJECT_NAME);
        }
    }

    public static class ServiceTunnelTargetUrlProperty
    extends AbstractStringConfigProperty {
        public static final String PROCESS_SERVLET_MAPPING = "/process";

        public String getDefaultValue() {
            String backendUrl = (String)((BackendUrlProperty)((Object)BEANS.get(BackendUrlProperty.class))).getValue();
            if (StringUtility.hasText((CharSequence)backendUrl)) {
                return String.valueOf(backendUrl) + PROCESS_SERVLET_MAPPING;
            }
            return null;
        }

        public String description() {
            return String.format("Specifies the URL to the ServiceTunnelServlet on the backend server.\nBy default this property points to the value of property '%s' with '%s' appended.", ((BackendUrlProperty)((Object)BEANS.get(BackendUrlProperty.class))).getKey(), PROCESS_SERVLET_MAPPING);
        }

        public String getKey() {
            return "scout.servicetunnel.targetUrl";
        }
    }
}

