/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.clientnotification;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationAddress;

public class ClientNotificationAddress
implements IClientNotificationAddress {
    private static final long serialVersionUID = 1L;
    private final Set<String> m_sessionIds = new HashSet<String>();
    private final Set<String> m_userIds = new HashSet<String>();
    private boolean m_notifyAllSessions = false;
    private boolean m_notifyAllNodes = false;

    protected ClientNotificationAddress() {
    }

    public static ClientNotificationAddress createSessionAddress(Set<String> sessionIds) {
        return new ClientNotificationAddress().withSessionIds(sessionIds);
    }

    public static ClientNotificationAddress createUserAddress(Set<String> userIds) {
        return new ClientNotificationAddress().withUserIds(userIds);
    }

    public static ClientNotificationAddress createAllSessionsAddress() {
        return new ClientNotificationAddress().withNotifyAllSessions(true);
    }

    public static ClientNotificationAddress createAllNodesAddress() {
        return new ClientNotificationAddress().withNotifyAllNodes(true);
    }

    @Override
    public Set<String> getSessionIds() {
        return this.m_sessionIds;
    }

    @Override
    public Set<String> getUserIds() {
        return this.m_userIds;
    }

    @Override
    public boolean isNotifyAllSessions() {
        return this.m_notifyAllSessions;
    }

    @Override
    public boolean isNotifyAllNodes() {
        return this.m_notifyAllNodes;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.attr("sessions", this.getSessionIds());
        builder.attr("userIds", this.getUserIds());
        builder.attr("notifyAllSessions", this.isNotifyAllSessions());
        builder.attr("notifyAllNodes", this.isNotifyAllNodes());
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.m_notifyAllSessions) {
            result = 31 * result + (this.m_notifyAllSessions ? 1431 : 1437);
        } else if (this.m_notifyAllNodes) {
            result = 31 * result + (this.m_notifyAllNodes ? 1231 : 1237);
        } else {
            result = 31 * result + (this.m_sessionIds == null ? 0 : this.m_sessionIds.hashCode());
            result = 31 * result + (this.m_userIds == null ? 0 : this.m_userIds.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientNotificationAddress other = (ClientNotificationAddress)obj;
        if (this.m_notifyAllSessions) {
            return other.m_notifyAllSessions;
        }
        if (this.m_notifyAllNodes) {
            return other.m_notifyAllNodes;
        }
        if (this.m_sessionIds == null ? other.m_sessionIds != null : !this.m_sessionIds.equals(other.m_sessionIds)) {
            return false;
        }
        return !(this.m_userIds == null ? other.m_userIds != null : !this.m_userIds.equals(other.m_userIds));
    }

    protected ClientNotificationAddress withSessionIds(Set<String> sessionIds) {
        this.m_sessionIds.addAll(sessionIds);
        return this;
    }

    protected ClientNotificationAddress withUserIds(Set<String> userIds) {
        this.m_userIds.addAll(userIds);
        return this;
    }

    protected ClientNotificationAddress withNotifyAllSessions(boolean notifyAllSessions) {
        this.m_notifyAllSessions = notifyAllSessions;
        return this;
    }

    protected ClientNotificationAddress withNotifyAllNodes(boolean notifyAllNodes) {
        this.m_notifyAllNodes = notifyAllNodes;
        return this;
    }
}

