/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;
import org.eclipse.scout.rt.shared.csv.ArrayConsumer;
import org.eclipse.scout.rt.shared.csv.IDataConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvHelper {
    public static final String IGNORED_COLUMN_NAME = "null";
    private static final Logger LOG = LoggerFactory.getLogger(CsvHelper.class);
    private final Locale m_locale;
    private final char m_separatorChar;
    private final char m_textDelimiterChar;
    private final String m_lineSeparator;
    private int m_colCount;
    private List<String> m_colNames;
    private List<String> m_colTypes;
    private List<Format> m_colFormat;
    private boolean[] m_ignoredColumns;
    private boolean m_encodeLineSeparator;

    public CsvHelper() {
        this(null, ',', '\"', "\n");
    }

    public CsvHelper(Locale locale, String separatorChar, String textDelimiterChar, String lineSeparator) {
        this(locale, separatorChar != null && !separatorChar.isEmpty() ? separatorChar.charAt(0) : (char)'\u0000', textDelimiterChar != null && !textDelimiterChar.isEmpty() ? textDelimiterChar.charAt(0) : (char)'\u0000', lineSeparator);
    }

    public CsvHelper(Locale locale, char separatorChar, char textDelimiterChar, String lineSeparator) {
        this.m_locale = locale == null ? NlsLocale.get() : locale;
        this.m_separatorChar = (char)(separatorChar != 0 ? separatorChar : 59);
        this.m_textDelimiterChar = (char)(textDelimiterChar != 0 ? textDelimiterChar : 34);
        this.m_lineSeparator = lineSeparator != null ? lineSeparator : "\n";
        this.m_colFormat = new ArrayList<Format>();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public char getSeparatorChar() {
        return this.m_separatorChar;
    }

    public char getTextDelimiterChar() {
        return this.m_textDelimiterChar;
    }

    public String getLineSeparator() {
        return this.m_lineSeparator;
    }

    public boolean isEncodeLineSeparator() {
        return this.m_encodeLineSeparator;
    }

    public void setEncodeLineSeparator(boolean encodeLineSeparator) {
        this.m_encodeLineSeparator = encodeLineSeparator;
    }

    public List<String> getColumnNames() {
        return CollectionUtility.arrayList(this.m_colNames);
    }

    public void setColumnNames(List<String> list) {
        this.m_colNames = new ArrayList<String>(list);
        this.m_colCount = Math.max(this.m_colCount, this.m_colNames.size());
        this.m_ignoredColumns = new boolean[this.m_colNames.size()];
        int i = 0;
        while (i < this.m_colNames.size()) {
            this.m_ignoredColumns[i] = IGNORED_COLUMN_NAME.equals(this.m_colNames.get(i));
            ++i;
        }
    }

    public List<String> getColumnTypes() {
        return CollectionUtility.arrayList(this.m_colTypes);
    }

    public void setColumnTypes(List<String> list) {
        this.m_colTypes = new ArrayList<String>(list.size());
        this.m_colFormat = new ArrayList<Format>(list.size());
        for (String s : list) {
            Format f = this.getFormat(s);
            if (f == null) {
                s = "string";
            }
            this.m_colTypes.add(s);
            this.m_colFormat.add(f);
        }
        this.m_colCount = Math.max(this.m_colCount, this.m_colTypes.size());
    }

    protected int getColCount() {
        return this.m_colCount;
    }

    protected Format getFormat(String s) {
        if (s == null) {
            return null;
        }
        String sLow = StringUtility.lowercase((String)s);
        if (sLow.startsWith("date")) {
            if (s.length() >= 5) {
                return new SimpleDateFormat(s.substring(5), this.getLocale());
            }
            return ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateInstance(3, this.getLocale());
        }
        if (sLow.startsWith("integer")) {
            if (s.length() >= 8) {
                DecimalFormat f = new DecimalFormat(s.substring(8), new DecimalFormatSymbols(this.getLocale()));
                ((NumberFormat)f).setParseIntegerOnly(true);
                return f;
            }
            return ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getIntegerInstance(this.getLocale());
        }
        if (sLow.startsWith("float")) {
            if (s.length() >= 6) {
                return new DecimalFormat(s.substring(6), new DecimalFormatSymbols(this.getLocale()));
            }
            return ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(this.getLocale());
        }
        return null;
    }

    public List<Boolean> getIgnoredColumns() {
        if (this.m_ignoredColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<Boolean> ignoredColumns = new ArrayList<Boolean>(this.m_ignoredColumns.length);
        boolean[] blArray = this.m_ignoredColumns;
        int n = this.m_ignoredColumns.length;
        int n2 = 0;
        while (n2 < n) {
            boolean m_ignoredColumn = blArray[n2];
            ignoredColumns.add(m_ignoredColumn);
            ++n2;
        }
        return ignoredColumns;
    }

    public Object[][] importData(Reader reader, int headerRowCount, List<String> columnTypes, int rowCount) {
        if (columnTypes != null) {
            this.setColumnTypes(columnTypes);
        }
        ArrayConsumer cons = new ArrayConsumer();
        this.importData(cons, reader, false, false, headerRowCount, rowCount);
        Object[][] result = cons.getData();
        return result;
    }

    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount) {
        this.importData(dataConsumer, reader, readNameHeader, readTypeHeader, headerRowCount, -1);
    }

    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount, int rowCount) {
        this.importData(dataConsumer, reader, readNameHeader, readTypeHeader, headerRowCount, rowCount, false);
    }

    /*
     * Unable to fully structure code
     */
    public void importData(IDataConsumer dataConsumer, Reader reader, boolean readNameHeader, boolean readTypeHeader, int headerRowCount, int rowCount, boolean allowVariableColumnCount) {
        cell = null;
        colIndex = 0;
        lineNr = -1;
        if (rowCount < 0) {
            rowCount = 0x7FFFFFFF;
        }
        try {
            if (readNameHeader) {
                list = this.importRow(reader);
                if (list != null) {
                    this.setColumnNames(list);
                }
                --headerRowCount;
            }
            if (readTypeHeader) {
                list = this.importRow(reader);
                if (list != null) {
                    this.setColumnTypes(list);
                }
                --headerRowCount;
            }
            while (headerRowCount > 0) {
                this.importRow(reader);
                --headerRowCount;
            }
            lineNr = 1;
            ** GOTO lbl42
            {
                cellList.add(cellList.size(), null);
                do {
                    if (allowVariableColumnCount && cellList.size() < this.getColumnNames().size()) continue block5;
                    objList = new ArrayList<Object>(cellList.size());
                    colIndex = 0;
                    while (colIndex < cellList.size()) {
                        if (this.m_ignoredColumns == null || this.m_ignoredColumns.length == 0 || this.m_ignoredColumns.length < colIndex || !this.m_ignoredColumns[colIndex]) {
                            cell = cellList.get(colIndex);
                            try {
                                objList.add(this.importCell(cell, this.getColumnFormat(colIndex)));
                            }
                            catch (RuntimeException e) {
                                throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("cell", (Object)cell, new Object[0]).withContextInfo("colIndex", (Object)colIndex, new Object[0]);
                            }
                        }
                        ++colIndex;
                    }
                    dataConsumer.processRow(lineNr, objList);
                    ++lineNr;
lbl42:
                    // 2 sources

                } while (lineNr <= rowCount && (cellList = this.importRow(reader)) != null);
            }
        }
        catch (IOException | RuntimeException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("lineNr", (Object)lineNr, new Object[0]);
        }
    }

    public void exportData(Object[][] data, File f, String encoding, List<String> columnNames, boolean writeColumnNames, List<String> columnTypes, boolean writeColumnTypes) {
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);){
                this.exportData(data, writer, columnNames, writeColumnNames, columnTypes, writeColumnTypes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException(f.getAbsolutePath(), new Object[]{e});
        }
    }

    public void exportData(Object[][] data, Writer writer, List<String> columnNames, boolean writeColumnNames, List<String> columnTypes, boolean writeColumnTypes) {
        try {
            if (columnNames != null) {
                this.setColumnNames(columnNames);
            }
            if (columnTypes != null) {
                this.setColumnTypes(columnTypes);
            }
            this.exportHeaderRows(writer, writeColumnNames, writeColumnTypes);
            Object[][] objectArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] row = objectArray[n2];
                this.exportDataRow(row, writer, false);
                ++n2;
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.warn("Could not close writer", (Throwable)e);
            }
        }
    }

    public void exportHeaderRows(Writer writer, boolean writeNames, boolean writeTypes) {
        String line = null;
        int colIndex = 0;
        Object val = null;
        String cell = null;
        try {
            if (writeNames) {
                line = this.exportRow(this.m_colNames);
                writer.write(line);
                writer.write(this.getLineSeparator());
            }
            if (writeTypes) {
                line = this.exportRow(this.m_colTypes);
                writer.write(line);
                writer.write(this.getLineSeparator());
            }
        }
        catch (IOException e) {
            throw new ProcessingException("line=" + line + " colIndex=" + colIndex + " value=" + val + " cell=" + cell, new Object[]{e});
        }
    }

    public void exportDataRow(Object[] row, Writer writer) {
        this.exportDataRow(row, writer, true);
    }

    public void exportDataRow(Object[] row, Writer writer, boolean closeWriter) {
        String line = null;
        Object val = null;
        String cell = null;
        try {
            try {
                ArrayList<String> rowStrings = new ArrayList<String>();
                rowStrings.clear();
                int i = 0;
                while (i < row.length) {
                    val = row[i];
                    cell = this.exportCell(val, this.getColumnFormat(i));
                    rowStrings.add(cell);
                    ++i;
                }
                line = this.exportRow(rowStrings);
                writer.write(line);
                writer.write(this.getLineSeparator());
            }
            catch (IOException e) {
                throw new ProcessingException("line=" + Arrays.asList(row), new Object[]{e});
            }
        }
        finally {
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    LOG.warn("Could not close writer", (Throwable)e);
                }
            }
        }
    }

    protected Format getColumnFormat(int colIndex) {
        if (colIndex < this.m_colFormat.size()) {
            return this.m_colFormat.get(colIndex);
        }
        return null;
    }

    protected List<String> importRow(Reader reader) throws IOException {
        ArrayList<String> cellList = new ArrayList<String>(Math.max(this.getColCount(), 2));
        boolean inString = false;
        StringBuilder curBuf = new StringBuilder();
        int ch = reader.read();
        while (ch == 10 || ch == 13) {
            ch = reader.read();
        }
        if (ch < 0) {
            return null;
        }
        while (true) {
            if (ch >= 0 && inString) {
                if (ch == this.getTextDelimiterChar()) {
                    inString = false;
                }
                curBuf.append((char)ch);
            } else if (ch == this.getSeparatorChar() || ch < 0 || ch == 10 || ch == 13) {
                String token = curBuf.toString();
                curBuf.setLength(0);
                int tokenLen = token.length();
                if (tokenLen > 0) {
                    if (token.charAt(0) == this.getTextDelimiterChar() && token.charAt(tokenLen - 1) == this.getTextDelimiterChar()) {
                        token = token.substring(1, tokenLen - 1);
                    }
                    if (token.isEmpty()) {
                        token = null;
                    }
                } else {
                    token = null;
                }
                token = this.decodeText(token);
                cellList.add(token);
                if (ch < 0 || ch == 10 || ch == 13) {
                    break;
                }
            } else if (ch == this.getTextDelimiterChar()) {
                inString = true;
                curBuf.append((char)ch);
            } else {
                curBuf.append((char)ch);
            }
            ch = reader.read();
        }
        if (cellList.isEmpty() && ch < 0) {
            cellList = null;
        }
        return cellList;
    }

    protected String exportRow(Collection<String> strings) {
        StringBuilder buf = new StringBuilder();
        if (strings != null) {
            Iterator<String> it = strings.iterator();
            while (it.hasNext()) {
                buf.append(this.encodeText(it.next()));
                if (!it.hasNext() || this.getSeparatorChar() == '\u0000') continue;
                buf.append(this.getSeparatorChar());
            }
        }
        return buf.toString();
    }

    protected Object importCell(String text, Format f) {
        if (text != null && f != null) {
            try {
                return f.parseObject(text.trim());
            }
            catch (ParseException e) {
                throw new ProcessingException("Cannot parse '{}' using format '{}'", new Object[]{text, f, e});
            }
        }
        return text;
    }

    protected String exportCell(Object o, Format f) {
        if (f != null && o != null) {
            return f.format(o);
        }
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    protected String encodeText(String text) {
        if (this.getTextDelimiterChar() != '\u0000' && text != null && ((text = this.stringReplace(text, "" + this.getTextDelimiterChar(), "" + this.getTextDelimiterChar() + this.getTextDelimiterChar())).indexOf(this.getSeparatorChar()) >= 0 || text.indexOf(this.getTextDelimiterChar()) >= 0 || this.isEncodeLineSeparator() && text.contains(this.getLineSeparator()))) {
            text = String.valueOf(this.getTextDelimiterChar()) + text + this.getTextDelimiterChar();
        }
        return text;
    }

    protected String decodeText(String text) {
        if (text != null && !text.isEmpty() && this.getTextDelimiterChar() != '\u0000') {
            if (text.charAt(0) == this.getTextDelimiterChar() && text.charAt(text.length() - 1) == this.getTextDelimiterChar()) {
                text = text.substring(1, text.length() - 1);
            }
            text = this.stringReplace(text, "" + this.getTextDelimiterChar() + this.getTextDelimiterChar(), "" + this.getTextDelimiterChar());
        }
        return text;
    }

    protected String stringReplace(String s, String sOld, String sNew) {
        String string = sNew = sNew == null ? "" : sNew;
        if (s == null || sOld == null) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        int oldLen = sOld.length();
        int pos = 0;
        int i = s.indexOf(sOld);
        while (i >= 0) {
            buf.append(s.substring(pos, i));
            buf.append(sNew);
            pos = i + oldLen;
            i = s.indexOf(sOld, pos);
        }
        buf.append(s.substring(pos));
        return buf.toString();
    }

    public List<String> getColumnNames(File f) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader r = new FileReader(f);){
                List<String> result = this.getCurrentRow(r);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), new Object[]{e});
        }
    }

    public List<String> getCurrentRow(Reader reader) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                return this.importRow(bufferedReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("reading header row", new Object[]{e});
        }
    }
}

