/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.basic.graph;

import java.io.Serializable;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphLineStyle;
import org.eclipse.scout.rt.shared.data.basic.graph.GraphNode;

public class GraphEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GraphNode m_source;
    private GraphNode m_target;
    private String m_label;
    private GraphLineStyle m_style;
    private boolean m_directed;

    protected GraphEdge() {
    }

    public static GraphEdge create() {
        return new GraphEdge();
    }

    public static GraphEdge create(GraphNode source, GraphNode target, String label, GraphLineStyle style, boolean directed) {
        return GraphEdge.create().withSource(source).withTarget(target).withLabel(label).withStyle(style).withDirected(directed);
    }

    public GraphEdge withSource(GraphNode source) {
        this.setSource(source);
        return this;
    }

    public GraphEdge withTarget(GraphNode target) {
        this.setTarget(target);
        return this;
    }

    public GraphEdge withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public GraphEdge withStyle(GraphLineStyle style) {
        this.setStyle(style);
        return this;
    }

    public GraphEdge withDirected(boolean directed) {
        this.setDirected(directed);
        return this;
    }

    public GraphNode getSource() {
        return this.m_source;
    }

    protected void setSource(GraphNode source) {
        this.m_source = source;
    }

    public GraphNode getTarget() {
        return this.m_target;
    }

    protected void setTarget(GraphNode target) {
        this.m_target = target;
    }

    public String getLabel() {
        return this.m_label;
    }

    protected void setLabel(String label) {
        this.m_label = label;
    }

    public GraphLineStyle getStyle() {
        return this.m_style;
    }

    protected void setStyle(GraphLineStyle style) {
        this.m_style = style;
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    protected void setDirected(boolean directed) {
        this.m_directed = directed;
    }
}

