/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelEntity;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataModel
implements IDataModel,
Serializable,
IContributionOwner {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataModel.class);
    private boolean m_calledInitializer;
    private List<IDataModelAttribute> m_attributes;
    private List<IDataModelEntity> m_entities;
    private IContributionOwner m_contributionHolder;

    public AbstractDataModel() {
        this(true);
    }

    public AbstractDataModel(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    @Override
    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    @Override
    public final <T> T getContribution(Class<T> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    @Override
    public final <T> T optContribution(Class<T> contribution) {
        return this.m_contributionHolder.optContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_calledInitializer) {
            this.m_calledInitializer = true;
            this.initConfig();
        }
    }

    protected List<IDataModelAttribute> createAttributes(Object holder) {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(holder.getClass());
        List filtered = ConfigurationUtility.removeReplacedClasses((List)ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)ConfigurationUtility.filterClasses((Class[])all, IDataModelAttribute.class), IDataModelAttribute.class));
        List<IDataModelAttribute> contributedAttributes = this.m_contributionHolder.getContributionsByClass(IDataModelAttribute.class);
        OrderedCollection attributes = new OrderedCollection();
        for (Class attributeClazz : filtered) {
            IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)holder, (Class)attributeClazz);
            attributes.addOrdered((IOrdered)a);
        }
        attributes.addAllOrdered(contributedAttributes);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)attributes);
        return attributes.getOrderedList();
    }

    protected List<IDataModelEntity> createEntities(Object holder) {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(holder.getClass());
        List filtered = ConfigurationUtility.removeReplacedClasses((List)ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)ConfigurationUtility.filterClasses((Class[])all, IDataModelEntity.class), IDataModelEntity.class));
        List<IDataModelEntity> contributedEntities = this.m_contributionHolder.getContributionsByClass(IDataModelEntity.class);
        OrderedCollection entities = new OrderedCollection();
        for (Class dataModelEntityClazz : filtered) {
            entities.addOrdered((IOrdered)((IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)holder, (Class)dataModelEntityClazz)));
        }
        entities.addAllOrdered(contributedEntities);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)entities);
        return entities.getOrderedList();
    }

    protected List<IDataModelAttribute> createAttributes() {
        return this.createAttributes(this);
    }

    protected List<IDataModelEntity> createEntities() {
        return this.createEntities(this);
    }

    protected void initConfig() {
        this.m_contributionHolder = new ContributionComposite(this);
        this.m_attributes = this.createAttributes();
        for (IDataModelAttribute a : this.m_attributes) {
            if (!(a instanceof AbstractDataModelAttribute)) continue;
            ((AbstractDataModelAttribute)a).setParentEntity(null);
        }
        this.m_entities = this.createEntities();
        HashMap<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap = new HashMap<Class<? extends IDataModelEntity>, IDataModelEntity>(this.m_entities.size());
        for (IDataModelEntity e : this.m_entities) {
            if (e instanceof AbstractDataModelEntity) {
                ((AbstractDataModelEntity)e).setParentEntity(null);
            }
            instanceMap.put(e.getClass(), e);
        }
        for (IDataModelEntity e : this.m_entities) {
            e.initializeChildEntities(instanceMap);
        }
    }

    @Override
    public void init() {
        for (IDataModelEntity e : this.getEntities()) {
            try {
                e.initEntity();
            }
            catch (RuntimeException ex) {
                LOG.error("entity {}", (Object)e, (Object)ex);
            }
        }
        for (IDataModelAttribute a : this.getAttributes()) {
            try {
                a.initAttribute();
            }
            catch (RuntimeException ex) {
                LOG.error("attribute {}", (Object)a, (Object)ex);
            }
        }
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return CollectionUtility.arrayList(this.m_attributes);
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return CollectionUtility.arrayList(this.m_entities);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }
}

