/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.security.Permission;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeAggregationTypeProvider;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOperatorProvider;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.data.model.DataModelAttributeChains;
import org.eclipse.scout.rt.shared.extension.data.model.IDataModelAttributeExtension;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallFactoryService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="350b5965-e92d-4f7e-b7b7-7135a572ff91")
public abstract class AbstractDataModelAttribute
extends AbstractPropertyObserver
implements IDataModelAttribute,
Serializable,
IExtensibleObject {
    private static final long serialVersionUID = 1L;
    private static final String ALLOW_NULL_OPERATOR = "ALLOW_NULL_OPERATOR";
    private static final String ALLOW_NOT_OPERATOR = "ALLOW_NOT_OPERATOR";
    private static final String AGGREGATION_ENABLED = "AGGREGATION_ENABLED";
    private static final String ACTIVE_FILTER_ENABLED = "ACTIVE_FILTER_ENABLED";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataModelAttribute.class);
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper("ALLOW_NULL_OPERATOR", "ALLOW_NOT_OPERATOR", "AGGREGATION_ENABLED", "ACTIVE_FILTER_ENABLED");
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper("VISIBLE", "VISIBLE_GRANTED");
    private String m_text;
    private int m_type;
    private double m_order;
    private List<? extends IDataModelAttributeOp> m_operators;
    private int[] m_aggregationTypes;
    private String m_iconId;
    private Class<? extends ICodeType> m_codeTypeClass;
    private ILookupCall<?> m_lookupCall;
    private boolean m_searchRequired;
    private Permission m_visiblePermission;
    private IDataModelEntity m_parentEntity;
    private final ObjectExtensions<AbstractDataModelAttribute, IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> m_objectExtensions = new ObjectExtensions(this, false);
    private byte m_visible;
    private byte m_flags;

    public AbstractDataModelAttribute() {
        this(true);
    }

    public AbstractDataModelAttribute(boolean callInitConfig) {
        if (callInitConfig) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IDataModelAttribute.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        IDataModelEntity parentEntity = this.getParentEntity();
        if (parentEntity != null) {
            return String.valueOf(simpleClassId) + "_" + parentEntity.classId();
        }
        return simpleClassId;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=30.0)
    protected Class<? extends ILookupCall<?>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=40.0)
    protected Class<? extends ICodeType<?, ?>> getConfiguredCodeType() {
        return null;
    }

    @Order(value=50.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredSearchRequired() {
        return false;
    }

    @ConfigProperty(value="COMPOSER_ATTRIBUTE_TYPE")
    @Order(value=70.0)
    protected int getConfiguredType() {
        return 15;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredNullOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredNotOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=105.0)
    protected boolean getConfiguredAggregationEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=120.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=130.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAttribute() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPrepareLookup(ILookupCall<?> call) {
    }

    @Override
    public Map<String, String> getMetaDataOfAttribute() {
        return null;
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        Class<ILookupCall<?>> lookupCallClass;
        this.m_visible = (byte)-1;
        this.setNotOperatorEnabled(this.getConfiguredNotOperatorEnabled());
        this.setNullOperatorEnabled(this.getConfiguredNullOperatorEnabled());
        this.setAggregationEnabled(this.getConfiguredAggregationEnabled());
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setType(this.getConfiguredType());
        this.setVisible(this.getConfiguredVisible());
        this.setSearchRequired(this.getConfiguredSearchRequired());
        this.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        this.setOrder(this.calculateViewOrder());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall call = (ILookupCall)BEANS.get(lookupCallClass);
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + lookupCallClass.getName() + "'.", new Object[]{e}));
            }
        }
        this.injectOperators();
        this.injectAggregationTypes();
    }

    public final List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IDataModelAttributeExtension<? extends AbstractDataModelAttribute> createLocalExtension() {
        return new LocalDataModelAttributeExtension<AbstractDataModelAttribute>(this);
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    protected void injectOperators() {
        ArrayList<IDataModelAttributeOp> operatorList = new ArrayList<IDataModelAttributeOp>();
        for (IDataModelAttributeOperatorProvider injector : BEANS.all(IDataModelAttributeOperatorProvider.class)) {
            injector.injectOperators(this, operatorList);
        }
        this.setOperators(operatorList);
    }

    protected void injectAggregationTypes() {
        ArrayList<Integer> aggregationTypeList = new ArrayList<Integer>();
        for (IDataModelAttributeAggregationTypeProvider injector : BEANS.all(IDataModelAttributeAggregationTypeProvider.class)) {
            injector.injectAggregationTypes(this, aggregationTypeList);
        }
        int[] a = new int[aggregationTypeList.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (Integer)aggregationTypeList.get(i);
            ++i;
        }
        this.setAggregationTypes(a);
    }

    @Override
    public final void initAttribute() {
        this.interceptInitAttribute();
    }

    @Override
    public void prepareLookup(ILookupCall<?> call) {
        this.interceptPrepareLookup(call);
    }

    public double getOrder() {
        return this.m_order;
    }

    public void setOrder(double order) {
        this.m_order = order;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public void setType(int i) {
        this.m_type = i;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public List<IDataModelAttributeOp> getOperators() {
        return CollectionUtility.arrayList(this.m_operators);
    }

    @Override
    public void setOperators(List<? extends IDataModelAttributeOp> ops) {
        this.m_operators = CollectionUtility.arrayList(ops);
    }

    @Override
    public int[] getAggregationTypes() {
        return this.m_aggregationTypes != null ? this.m_aggregationTypes : new int[]{};
    }

    @Override
    public void setAggregationTypes(int[] aggregationTypes) {
        this.m_aggregationTypes = aggregationTypes;
    }

    @Override
    public boolean containsAggregationType(int agType) {
        if (this.m_aggregationTypes == null) {
            return false;
        }
        int[] nArray = this.m_aggregationTypes;
        int n = this.m_aggregationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == agType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isNullOperatorEnabled() {
        return FLAGS_BIT_HELPER.isBitSet(ALLOW_NULL_OPERATOR, this.m_flags);
    }

    @Override
    public void setNullOperatorEnabled(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ALLOW_NULL_OPERATOR, b, this.m_flags);
    }

    @Override
    public boolean isAggregationEnabled() {
        return FLAGS_BIT_HELPER.isBitSet(AGGREGATION_ENABLED, this.m_flags);
    }

    @Override
    public void setAggregationEnabled(boolean aggregationEnabled) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(AGGREGATION_ENABLED, aggregationEnabled, this.m_flags);
        if (this.m_aggregationTypes != null) {
            this.injectAggregationTypes();
        }
    }

    @Override
    public boolean isNotOperatorEnabled() {
        return FLAGS_BIT_HELPER.isBitSet(ALLOW_NOT_OPERATOR, this.m_flags);
    }

    @Override
    public void setNotOperatorEnabled(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ALLOW_NOT_OPERATOR, b, this.m_flags);
    }

    @Override
    public Class<? extends ICodeType<?, ?>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, ?>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = ((ICodeLookupCallFactoryService)BEANS.get(ICodeLookupCallFactoryService.class)).newInstance(this.m_codeTypeClass);
        }
    }

    @Override
    public ILookupCall<Object> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<?> call) {
        this.m_lookupCall = call;
    }

    @Override
    public boolean isSearchRequired() {
        return this.m_searchRequired;
    }

    @Override
    public void setSearchRequired(boolean searchRequired) {
        this.m_searchRequired = searchRequired;
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.setVisiblePermissionInternal(p);
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    protected void setVisiblePermissionInternal(Permission p) {
        this.m_visiblePermission = p;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return NamedBitMaskHelper.allBitsSet(this.m_visible);
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, "VISIBLE");
    }

    @Override
    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
    }

    @Override
    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public void setActiveFilterEnabled(boolean active) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ACTIVE_FILTER_ENABLED, active, this.m_flags);
    }

    @Override
    public boolean isActiveFilterEnabled() {
        return FLAGS_BIT_HELPER.isBitSet(ACTIVE_FILTER_ENABLED, this.m_flags);
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    @Override
    public boolean isMultiValued() {
        switch (this.getType()) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String formatValue(Object rawValue) {
        if (rawValue == null) {
            return this.formatNullValue();
        }
        switch (this.getType()) {
            case 3: 
            case 4: 
            case 16: {
                return this.formatSmart(rawValue, this.getCodeTypeClass(), this.getLookupCall());
            }
            case 5: {
                return this.formatDate(rawValue, true, false);
            }
            case 7: {
                return this.formatDate(rawValue, true, true);
            }
            case 6: {
                return this.formatDate(rawValue, false, true);
            }
            case 8: {
                return this.formatInteger(rawValue, true);
            }
            case 9: {
                return this.formatLong(rawValue, true);
            }
            case 10: {
                return this.formatBigDecimal(rawValue, true, false);
            }
            case 11: {
                return this.formatInteger(rawValue, false);
            }
            case 12: {
                return this.formatLong(rawValue, false);
            }
            case 13: {
                return this.formatBigDecimal(rawValue, false, false);
            }
            case 14: {
                return this.formatBigDecimal(rawValue, true, true);
            }
            case 15: 
            case 18: {
                return this.formatString(rawValue);
            }
        }
        return this.formatObject(rawValue);
    }

    protected String formatNullValue() {
        return null;
    }

    protected String formatDate(Object rawValue, boolean hasDate, boolean hasTime) {
        Date value = (Date)TypeCastUtility.castValue((Object)rawValue, Date.class);
        DateFormat df = null;
        df = hasDate && !hasTime ? ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateInstance(2, NlsLocale.get()) : (!hasDate && hasTime ? ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getTimeInstance(3, NlsLocale.get()) : ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateTimeInstance(3, 3, NlsLocale.get()));
        df.setLenient(true);
        return df.format(value);
    }

    protected String formatBigDecimal(Object rawValue, boolean groupingUsed, boolean percent) {
        BigDecimal value = (BigDecimal)TypeCastUtility.castValue((Object)rawValue, BigDecimal.class);
        DecimalFormat fmt = null;
        fmt = percent ? ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(NlsLocale.get()) : ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(NlsLocale.get());
        if (fmt instanceof DecimalFormat) {
            fmt.setMultiplier(1);
        }
        ((NumberFormat)fmt).setMinimumFractionDigits(2);
        ((NumberFormat)fmt).setMaximumFractionDigits(2);
        ((NumberFormat)fmt).setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatInteger(Object rawValue, boolean groupingUsed) {
        Integer value = (Integer)TypeCastUtility.castValue((Object)rawValue, Integer.class);
        DecimalFormat fmt = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(NlsLocale.get());
        ((NumberFormat)fmt).setMinimumFractionDigits(0);
        ((NumberFormat)fmt).setMaximumFractionDigits(0);
        ((NumberFormat)fmt).setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatLong(Object rawValue, boolean groupingUsed) {
        Long value = (Long)TypeCastUtility.castValue((Object)rawValue, Long.class);
        DecimalFormat fmt = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(NlsLocale.get());
        ((NumberFormat)fmt).setMinimumFractionDigits(0);
        ((NumberFormat)fmt).setMaximumFractionDigits(0);
        ((NumberFormat)fmt).setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatSmart(Object rawValue, Class<? extends ICodeType<?, ?>> codeTypeClass, ILookupCall<?> lookupCall) {
        ILookupCall<Object> call;
        if (codeTypeClass == null && lookupCall == null) {
            return null;
        }
        if (codeTypeClass != null) {
            call = ((ICodeLookupCallFactoryService)BEANS.get(ICodeLookupCallFactoryService.class)).newInstance(codeTypeClass);
        } else if (lookupCall instanceof LookupCall) {
            call = ((LookupCall)lookupCall).copy();
        } else {
            return null;
        }
        call.setKey(rawValue);
        call.setText(null);
        call.setAll(null);
        call.setRec(null);
        try {
            this.interceptPrepareLookup(call);
            List<ILookupRow<Object>> result = call.getDataByKey();
            if (result.size() == 1) {
                return result.get(0).getText();
            }
            if (result.size() > 1) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < result.size()) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(result.get(i).getText());
                    ++i;
                }
                return sb.toString();
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Execution of lookup call failed", (Throwable)e);
        }
        return "";
    }

    protected String formatString(Object rawValue) {
        return (String)TypeCastUtility.castValue((Object)rawValue, String.class);
    }

    protected String formatObject(Object rawValue) {
        return rawValue.toString();
    }

    protected final void interceptInitAttribute() {
        List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> extensions = this.getAllExtensions();
        DataModelAttributeChains.DataModelAttributeInitAttributeChain chain = new DataModelAttributeChains.DataModelAttributeInitAttributeChain(extensions);
        chain.execInitAttribute();
    }

    protected final void interceptPrepareLookup(ILookupCall<?> call) {
        List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> extensions = this.getAllExtensions();
        DataModelAttributeChains.DataModelAttributePrepareLookupChain chain = new DataModelAttributeChains.DataModelAttributePrepareLookupChain(extensions);
        chain.execPrepareLookup(call);
    }

    protected static class LocalDataModelAttributeExtension<OWNER extends AbstractDataModelAttribute>
    extends AbstractSerializableExtension<OWNER>
    implements IDataModelAttributeExtension<OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalDataModelAttributeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitAttribute(DataModelAttributeChains.DataModelAttributeInitAttributeChain chain) {
            ((AbstractDataModelAttribute)this.getOwner()).execInitAttribute();
        }

        @Override
        public void execPrepareLookup(DataModelAttributeChains.DataModelAttributePrepareLookupChain chain, ILookupCall<?> call) {
            ((AbstractDataModelAttribute)this.getOwner()).execPrepareLookup(call);
        }
    }
}

