/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.data.model.DataModelEntityChains;
import org.eclipse.scout.rt.shared.extension.data.model.IDataModelEntityExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="d64571d4-5521-45c3-84c2-a22294542747")
public abstract class AbstractDataModelEntity
extends AbstractPropertyObserver
implements IDataModelEntity,
Serializable,
IContributionOwner,
IExtensibleObject {
    private static final long serialVersionUID = 1L;
    private static final String INITIALIZED = "INITIALIZED";
    private static final String ONE_TO_MANY = "ONE_TO_MANY";
    private static final String INITIALIZED_CHILD_ENTITIES = "INITIALIZED_CHILD_ENTITIES";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataModelEntity.class);
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper("INITIALIZED", "ONE_TO_MANY", "INITIALIZED_CHILD_ENTITIES");
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper("VISIBLE", "VISIBLE_GRANTED");
    private double m_order;
    private Permission m_visiblePermission;
    private String m_text;
    private String m_iconId;
    private List<IDataModelAttribute> m_attributes = new ArrayList<IDataModelAttribute>();
    private List<IDataModelEntity> m_entities = new ArrayList<IDataModelEntity>();
    private IDataModelEntity m_parentEntity;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractDataModelEntity, IDataModelEntityExtension<? extends AbstractDataModelEntity>> m_objectExtensions = new ObjectExtensions(this, false);
    private byte m_flags;
    private byte m_visible;

    public AbstractDataModelEntity() {
        this(true);
    }

    public AbstractDataModelEntity(boolean callInitConfig) {
        if (callInitConfig) {
            this.callInitializer();
        }
    }

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    @Override
    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    @Override
    public final <T> T getContribution(Class<T> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    @Override
    public final <T> T optContribution(Class<T> contribution) {
        return this.m_contributionHolder.optContribution(contribution);
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IDataModelEntity.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
        IDataModelEntity parentEntity = this.getParentEntity();
        if (parentEntity != null) {
            return String.valueOf(simpleClassId) + "_" + parentEntity.classId();
        }
        return simpleClassId;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredOneToMany() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=60.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitEntity() {
    }

    private List<Class<? extends IDataModelAttribute>> getConfiguredAttributes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IDataModelAttribute.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    private List<Class<? extends IDataModelEntity>> getConfiguredEntities() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IDataModelEntity.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.m_visible = (byte)-1;
        this.m_contributionHolder = new ContributionComposite(this);
        this.setText(this.getConfiguredText());
        this.setIconId(this.getConfiguredIconId());
        this.setVisible(this.getConfiguredVisible());
        this.setOneToMany(this.getConfiguredOneToMany());
        this.setOrder(this.calculateViewOrder());
        List<Class<? extends IDataModelAttribute>> configuredAttributes = this.getConfiguredAttributes();
        List<IDataModelAttribute> contributedAttributes = this.m_contributionHolder.getContributionsByClass(IDataModelAttribute.class);
        OrderedCollection attributes = new OrderedCollection();
        for (Class<? extends IDataModelAttribute> c : configuredAttributes) {
            attributes.addOrdered((IOrdered)((IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this, c)));
        }
        attributes.addAllOrdered(contributedAttributes);
        this.injectAttributesInternal((OrderedCollection<IDataModelAttribute>)attributes);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)attributes);
        this.m_attributes = attributes.getOrderedList();
        for (IDataModelAttribute a : this.m_attributes) {
            if (!(a instanceof AbstractDataModelAttribute)) continue;
            ((AbstractDataModelAttribute)a).setParentEntity(this);
        }
        this.m_entities = new ArrayList<IDataModelEntity>();
    }

    public final List<? extends IDataModelEntityExtension<? extends AbstractDataModelEntity>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IDataModelEntityExtension<? extends AbstractDataModelEntity> createLocalExtension() {
        return new LocalDataModelEntityExtension<AbstractDataModelEntity>(this);
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    @Override
    public Map<String, String> getMetaDataOfEntity() {
        return null;
    }

    private boolean isInitialized() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALIZED, this.m_flags);
    }

    private void setInitialized() {
        this.m_flags = FLAGS_BIT_HELPER.setBit(INITIALIZED, this.m_flags);
    }

    @Override
    public final void initEntity() {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.interceptInitEntity();
        }
        catch (RuntimeException ex) {
            LOG.error("entity {}", (Object)this, (Object)ex);
        }
        for (IDataModelAttribute a : this.getAttributes()) {
            try {
                a.initAttribute();
            }
            catch (RuntimeException ex) {
                LOG.error("attribute {}/{}", new Object[]{this, a, ex});
            }
        }
        this.setInitialized();
        for (IDataModelEntity e : this.getEntities()) {
            try {
                e.initEntity();
            }
            catch (RuntimeException ex) {
                LOG.error("entity {}/{}", new Object[]{this, e, ex});
            }
        }
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.setVisiblePermissionInternal(p);
        boolean b = true;
        if (p != null) {
            b = ACCESS.check((Permission)p);
        }
        this.setVisibleGranted(b);
    }

    protected void setVisiblePermissionInternal(Permission p) {
        this.m_visiblePermission = p;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        this.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, "VISIBLE");
    }

    @Override
    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
        this.calculateVisible();
    }

    @Override
    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", NamedBitMaskHelper.allBitsSet(this.m_visible));
    }

    @Override
    public boolean isOneToMany() {
        return FLAGS_BIT_HELPER.isBitSet(ONE_TO_MANY, this.m_flags);
    }

    @Override
    public void setOneToMany(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ONE_TO_MANY, b, this.m_flags);
    }

    private boolean isInitializedChildEntities() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALIZED_CHILD_ENTITIES, this.m_flags);
    }

    private void setInitializedChildEntities() {
        this.m_flags = FLAGS_BIT_HELPER.setBit(INITIALIZED_CHILD_ENTITIES, this.m_flags);
    }

    public double getOrder() {
        return this.m_order;
    }

    public void setOrder(double order) {
        this.m_order = order;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return CollectionUtility.arrayList(this.m_attributes);
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return CollectionUtility.arrayList(this.m_entities);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    @Override
    public void initializeChildEntities(Map<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap) {
        if (this.isInitializedChildEntities()) {
            return;
        }
        this.setInitializedChildEntities();
        List<Class<? extends IDataModelEntity>> configuredEntities = this.getConfiguredEntities();
        List<IDataModelEntity> contributedEntities = this.m_contributionHolder.getContributionsByClass(IDataModelEntity.class);
        int numEntities = configuredEntities.size() + contributedEntities.size();
        HashSet<IDataModelEntity> newConfiguredInstances = new HashSet<IDataModelEntity>(numEntities);
        OrderedCollection entities = new OrderedCollection();
        for (Class<? extends IDataModelEntity> c : configuredEntities) {
            IDataModelEntity e = instanceMap.get(c);
            if (e == null) {
                e = (IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this, c);
                newConfiguredInstances.add(e);
                instanceMap.put(c, e);
            }
            entities.addOrdered((IOrdered)e);
        }
        newConfiguredInstances.addAll(contributedEntities);
        entities.addAllOrdered(contributedEntities);
        this.injectEntitiesInternal((OrderedCollection<IDataModelEntity>)entities);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)entities);
        this.m_entities.clear();
        this.m_entities.addAll(entities.getOrderedList());
        for (IDataModelEntity e : this.m_entities) {
            AbstractDataModelEntity adme;
            if (!(e instanceof AbstractDataModelEntity) || (adme = (AbstractDataModelEntity)e).getParentEntity() == this) continue;
            adme.setParentEntity(this);
        }
        for (IDataModelEntity e : this.m_entities) {
            if (!newConfiguredInstances.contains(e) && instanceMap.containsKey(e.getClass())) continue;
            e.initializeChildEntities(instanceMap);
        }
    }

    protected void injectAttributesInternal(OrderedCollection<IDataModelAttribute> attributes) {
    }

    protected void injectEntitiesInternal(OrderedCollection<IDataModelEntity> entities) {
    }

    protected final void interceptInitEntity() {
        List<? extends IDataModelEntityExtension<? extends AbstractDataModelEntity>> extensions = this.getAllExtensions();
        DataModelEntityChains.DataModelEntityInitEntityChain chain = new DataModelEntityChains.DataModelEntityInitEntityChain(extensions);
        chain.execInitEntity();
    }

    protected static class LocalDataModelEntityExtension<OWNER extends AbstractDataModelEntity>
    extends AbstractSerializableExtension<OWNER>
    implements IDataModelEntityExtension<OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalDataModelEntityExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitEntity(DataModelEntityChains.DataModelEntityInitEntityChain chain) {
            ((AbstractDataModelEntity)this.getOwner()).execInitEntity();
        }
    }
}

