/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;

public abstract class AbstractDataModelOp
implements IDataModelAttributeOp,
DataModelConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int m_operator;

    protected AbstractDataModelOp(int operator) {
        this.m_operator = operator;
    }

    @Override
    public final int getOperator() {
        return this.m_operator;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass() && this.m_operator == ((AbstractDataModelOp)obj).m_operator;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static String buildText(Integer aggregationType, String attributeText, String opText) {
        ArrayList valueTexts = CollectionUtility.emptyArrayList();
        return AbstractDataModelOp.buildText(aggregationType, attributeText, opText, valueTexts);
    }

    public static String buildText(Integer aggregationType, String attributeText, String opText, String valueTexts) {
        return AbstractDataModelOp.buildText(aggregationType, attributeText, opText, Collections.singletonList(valueTexts));
    }

    public static String buildText(Integer aggregationType, String attributeText, String opText, List<String> valueTexts) {
        String verboseValue;
        String text1 = null;
        if (valueTexts != null && !valueTexts.isEmpty()) {
            text1 = valueTexts.get(0);
        }
        String text2 = null;
        if (valueTexts != null && valueTexts.size() > 1) {
            text2 = valueTexts.get(1);
        }
        StringBuilder b = new StringBuilder();
        if (aggregationType != null) {
            switch (aggregationType) {
                case 5: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationAvg", (String[])new String[]{attributeText}));
                    break;
                }
                case 1: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationCount", (String[])new String[]{attributeText}));
                    break;
                }
                case 4: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationMax", (String[])new String[]{attributeText}));
                    break;
                }
                case 6: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationMedian", (String[])new String[]{attributeText}));
                    break;
                }
                case 3: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationMin", (String[])new String[]{attributeText}));
                    break;
                }
                case 2: {
                    b.append(TEXTS.get((String)"ComposerFieldAggregationSum", (String[])new String[]{attributeText}));
                    break;
                }
                default: {
                    b.append(attributeText);
                    break;
                }
            }
        } else {
            b.append(attributeText);
        }
        if (opText.contains("{0}")) {
            verboseValue = opText;
            if (verboseValue.contains("{0}") && text1 != null) {
                verboseValue = verboseValue.replace("{0}", text1);
            }
            if (verboseValue.contains("{1}") && text2 != null) {
                verboseValue = verboseValue.replace("{1}", text2);
            }
        } else {
            verboseValue = opText;
            if (text1 != null) {
                verboseValue = String.valueOf(verboseValue) + " " + text1;
            }
            if (text2 != null) {
                verboseValue = String.valueOf(verboseValue) + " " + text2;
            }
        }
        b.append(" ");
        b.append(verboseValue);
        return b.toString();
    }
}

