/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.model.AttributePath;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataModelUtility {
    private static final Logger LOG = LoggerFactory.getLogger(DataModelUtility.class);
    private static final Pattern PAT_EXTERNAL_ID = Pattern.compile("((.+)/)?([^/;]+)(;(.+))?");
    private static final Pattern PAT_SEMI_COLON = Pattern.compile("[;]");
    private static final Pattern PAT_NVPAIR = Pattern.compile("([^=]+)=(.*)");

    private DataModelUtility() {
    }

    public static String entityPathToExternalId(IDataModel dataModel, EntityPath entityPath) {
        if (entityPath == null || entityPath.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (IDataModelEntity e : entityPath.elements()) {
            if (buf.length() > 0) {
                buf.append("/");
            }
            buf.append(e.getClass().getSimpleName());
            buf.append(DataModelUtility.exportMetaData(e.getMetaDataOfEntity()));
        }
        String externalId = buf.toString();
        if (Platform.get().inDevelopmentMode() || LOG.isDebugEnabled()) {
            EntityPath verify = DataModelUtility.externalIdToEntityPath(dataModel, externalId);
            if (verify == null) {
                LOG.info("entity externalId {} resolves to null", (Object)externalId);
            } else if (!verify.equals(entityPath)) {
                LOG.info("entity externalId {} is not valid for {}", (Object)externalId, (Object)entityPath);
            }
        }
        return externalId;
    }

    public static String attributePathToExternalId(IDataModel dataModel, AttributePath attributePath) {
        if (attributePath == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(DataModelUtility.entityPathToExternalId(dataModel, attributePath.getEntityPath()));
        if (buf.length() > 0) {
            buf.append("/");
        }
        IDataModelAttribute a = attributePath.getAttribute();
        buf.append(a.getClass().getSimpleName());
        buf.append(DataModelUtility.exportMetaData(a.getMetaDataOfAttribute()));
        String externalId = buf.toString();
        if (Platform.get().inDevelopmentMode() || LOG.isDebugEnabled()) {
            AttributePath verify = DataModelUtility.externalIdToAttributePath(dataModel, externalId);
            if (verify == null) {
                LOG.info("attribute externalId {} resolves to null", (Object)externalId);
            } else if (!verify.equals(attributePath)) {
                LOG.info("attribute externalId {} is not valid for {}", (Object)externalId, (Object)attributePath);
            }
        }
        return externalId;
    }

    public static EntityPath externalIdToEntityPath(IDataModel dataModel, String externalId) {
        if (externalId == null || externalId.isEmpty()) {
            return EntityPath.EMPTY;
        }
        return DataModelUtility.resolveEntityPathRec(dataModel, externalId, EntityPath.EMPTY);
    }

    public static AttributePath externalIdToAttributePath(IDataModel dataModel, String externalId) {
        if (externalId == null || externalId.isEmpty()) {
            return null;
        }
        return DataModelUtility.resolveAttributePath(dataModel, externalId);
    }

    private static EntityPath resolveEntityPathRec(IDataModel dataModel, String externalId, EntityPath inputPath) {
        IDataModelEntity parentEntity;
        IDataModelEntity e;
        EntityPath resolvedPath;
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        Map<String, String> meta = DataModelUtility.importMetaData(m.group(5));
        if (folderName != null) {
            resolvedPath = DataModelUtility.resolveEntityPathRec(dataModel, folderName, inputPath);
            if (resolvedPath == null) {
                return null;
            }
        } else {
            resolvedPath = inputPath;
        }
        if ((e = (parentEntity = resolvedPath.lastElement()) != null ? DataModelUtility.findEntity(parentEntity.getEntities(), elemName, meta) : DataModelUtility.findEntity(dataModel.getEntities(), elemName, meta)) == null) {
            LOG.info("entity externalId {} resolves to null", (Object)externalId);
            return null;
        }
        return resolvedPath.addToEnd(e);
    }

    private static AttributePath resolveAttributePath(IDataModel dataModel, String externalId) {
        IDataModelEntity parentEntity;
        IDataModelAttribute a;
        EntityPath entityPath;
        Matcher m = PAT_EXTERNAL_ID.matcher(externalId);
        if (!m.matches()) {
            throw new IllegalArgumentException("externalId is invalid: " + externalId);
        }
        String folderName = m.group(2);
        String elemName = m.group(3);
        Map<String, String> meta = DataModelUtility.importMetaData(m.group(5));
        if (folderName != null) {
            entityPath = DataModelUtility.resolveEntityPathRec(dataModel, folderName, EntityPath.EMPTY);
            if (entityPath == null) {
                return null;
            }
        } else {
            entityPath = EntityPath.EMPTY;
        }
        if ((a = (parentEntity = entityPath.lastElement()) != null ? DataModelUtility.findAttribute(parentEntity.getAttributes(), elemName, meta) : DataModelUtility.findAttribute(dataModel.getAttributes(), elemName, meta)) == null) {
            LOG.info("attribute externalId {} resolves to null", (Object)externalId);
            return null;
        }
        return entityPath.addToEnd(a);
    }

    public static IDataModelEntity findEntity(List<? extends IDataModelEntity> entities, String simpleName, Map<String, String> metaData) {
        if (entities != null) {
            for (IDataModelEntity iDataModelEntity : entities) {
                if (!iDataModelEntity.getClass().getSimpleName().equals(simpleName) || !ObjectUtility.equals(iDataModelEntity.getMetaDataOfEntity(), metaData)) continue;
                return iDataModelEntity;
            }
        }
        return null;
    }

    public static IDataModelAttribute findAttribute(List<? extends IDataModelAttribute> attributes, String simpleName, Map<String, String> metaData) {
        if (attributes != null) {
            for (IDataModelAttribute iDataModelAttribute : attributes) {
                if (!iDataModelAttribute.getClass().getSimpleName().equals(simpleName) || !ObjectUtility.equals(iDataModelAttribute.getMetaDataOfAttribute(), metaData)) continue;
                return iDataModelAttribute;
            }
        }
        return null;
    }

    public static Map<String, String> importMetaData(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        String[] stringArray = PAT_SEMI_COLON.split(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            Matcher m = PAT_NVPAIR.matcher(e);
            if (m.matches()) {
                map.put(m.group(1), m.group(2));
            }
            ++n2;
        }
        return !map.isEmpty() ? map : null;
    }

    public static String exportMetaData(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(16);
        for (Map.Entry<String, String> e : map.entrySet()) {
            buf.append(";");
            buf.append(e.getKey());
            buf.append('=');
            if (e.getValue() == null) continue;
            buf.append(e.getValue());
        }
        return buf.toString();
    }

    public static List<? extends IDataModelEntity> sortEntities(List<? extends IDataModelEntity> entities) {
        if (CollectionUtility.isEmpty(entities)) {
            return CollectionUtility.emptyArrayList();
        }
        entities = new ArrayList<IDataModelEntity>(entities);
        entities.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return StringUtility.compareIgnoreCase((String)o1.getText(), (String)o2.getText());
        });
        return entities;
    }

    public static List<? extends IDataModelAttribute> sortAttributes(List<? extends IDataModelAttribute> attributes) {
        if (CollectionUtility.isEmpty(attributes)) {
            return CollectionUtility.emptyArrayList();
        }
        attributes = new ArrayList<IDataModelAttribute>(attributes);
        attributes.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getType() == 17 && o2.getType() != 17) {
                return -1;
            }
            if (o2.getType() == 17 && o1.getType() != 17) {
                return 1;
            }
            return StringUtility.compareIgnoreCase((String)o1.getText(), (String)o2.getText());
        });
        return attributes;
    }
}

