/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.deeplink;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;

public final class DeepLinkUtility {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    private DeepLinkUtility() {
    }

    public static String toSlug(String input) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }
}

