/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.shared.extension.IExtension;

public class ExtensionStack {
    private final Deque<List<? extends IExtension<?>>> m_extensions = new LinkedList();

    public ExtensionStack() {
        this(null);
    }

    public ExtensionStack(List<List<? extends IExtension<?>>> extensions) {
        if (extensions != null) {
            this.m_extensions.addAll(extensions);
        }
    }

    public void pushExtensions(List<? extends IExtension<?>> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            throw new IllegalArgumentException("extensions is null or empty");
        }
        this.m_extensions.push(extensions);
    }

    public void popExtensions(List<? extends IExtension<?>> extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("extensions is null");
        }
        if (this.m_extensions.isEmpty()) {
            throw new IllegalArgumentException("push/pop asymmetry; expected nothing but got " + extensions);
        }
        List<IExtension<?>> topOfStack = this.m_extensions.peek();
        if (this.m_extensions.isEmpty() || topOfStack != extensions) {
            throw new IllegalArgumentException("push/pop asymmetry; expected " + topOfStack.getClass() + " but got " + extensions);
        }
        this.m_extensions.pop();
    }

    public boolean isEmpty() {
        return this.m_extensions.isEmpty();
    }

    public Object findContextObjectByClass(Class<?> declaringClass) {
        for (List<IExtension<?>> segment : this.m_extensions) {
            for (IExtension<?> modelExtension : segment) {
                if (!declaringClass.isInstance(modelExtension)) continue;
                return modelExtension;
            }
        }
        return null;
    }

    public List<List<? extends IExtension<?>>> snapshot() {
        return new ArrayList(this.m_extensions);
    }
}

