/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.shared.extension.ExtensionContext;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;

public class ObjectExtensions<OWNER, EXTENSION extends IExtension<? extends OWNER>>
implements IExtensibleObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private final OWNER m_owner;
    private final boolean m_requiresNewScope;
    private List<EXTENSION> m_extensions;
    private ExtensionContext m_extensionContext;

    public ObjectExtensions(OWNER owner, boolean requiresNewScope) {
        this.m_owner = owner;
        this.m_requiresNewScope = requiresNewScope;
    }

    public List<EXTENSION> getAllExtensions() {
        if (this.m_extensions == null) {
            throw new IllegalStateException("The model object is not initialized: " + this.m_owner + ".");
        }
        return this.m_extensions;
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        if (c == null) {
            return null;
        }
        if (this.m_extensions == null) {
            throw new IllegalStateException("The model object is not initialized: " + this.m_owner + ".");
        }
        for (IExtension extension : this.m_extensions) {
            if (c != extension.getClass()) continue;
            return (T)((IExtension)c.cast(extension));
        }
        return null;
    }

    public void initConfig(EXTENSION localExtension, Runnable modelObjectInitializer) {
        this.initConfig(localExtension, false, modelObjectInitializer);
    }

    public void initConfigAndBackupExtensionContext(EXTENSION localExtension, Runnable modelObjectInitializer) {
        this.initConfig(localExtension, true, modelObjectInitializer);
    }

    protected void initConfig(EXTENSION localExtension, boolean backupExtensionContext, Runnable modelObjectInitializer) {
        if (this.m_extensions != null) {
            throw new IllegalStateException("The model object is already initialized: " + this.m_owner + ".");
        }
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class);
        if (extensionRegistry == null) {
            return;
        }
        Runnable initConfigRunnable = () -> {
            try {
                extensionRegistry.pushScope(this.m_owner.getClass());
                this.m_extensions = this.loadExtensions(localExtension);
                try {
                    extensionRegistry.pushExtensions(this.m_extensions);
                    if (backupExtensionContext) {
                        this.m_extensionContext = extensionRegistry.backupExtensionContext();
                    }
                    if (modelObjectInitializer != null) {
                        modelObjectInitializer.run();
                    }
                }
                finally {
                    extensionRegistry.popExtensions(this.m_extensions);
                }
            }
            finally {
                extensionRegistry.popScope();
            }
        };
        if (this.m_requiresNewScope) {
            extensionRegistry.runInContext(null, initConfigRunnable);
        } else {
            initConfigRunnable.run();
        }
    }

    public void runInExtensionContext(Runnable runnable) {
        IInternalExtensionRegistry extensionRegistry = (IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class);
        if (extensionRegistry == null) {
            return;
        }
        Assertions.assertNotNull((Object)this.m_extensionContext, (String)"The extension context has not been backed-up for {}. Use initConfigAndBackupExtensionContext for initializing this instance.", (Object[])new Object[]{this.m_owner});
        extensionRegistry.runInContext(this.m_extensionContext, runnable);
    }

    private List<EXTENSION> loadExtensions(EXTENSION localExtension) {
        List extensions = ((IInternalExtensionRegistry)BEANS.get(IInternalExtensionRegistry.class)).createExtensionsFor(this.m_owner);
        extensions.add(localExtension);
        return Collections.unmodifiableList(extensions);
    }
}

