/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.shared.http.HttpTransportFactoryProperty;
import org.eclipse.scout.rt.shared.http.IHttpTransportBuilder;
import org.eclipse.scout.rt.shared.http.IHttpTransportFactory;
import org.eclipse.scout.rt.shared.http.IHttpTransportManager;

public abstract class AbstractHttpTransportManager
implements IHttpTransportManager,
IPlatformListener {
    private volatile boolean m_active = true;
    private volatile boolean m_initialized = false;
    private volatile HttpTransport m_httpTransport;
    private volatile HttpRequestFactory m_httpRequestFactory;
    private volatile HttpRequestInitializer m_httpRequestInitializer;

    @Override
    public HttpTransport getHttpTransport() {
        this.init();
        return this.m_httpTransport;
    }

    @Override
    public HttpRequestFactory getHttpRequestFactory() {
        this.init();
        return this.m_httpRequestFactory;
    }

    protected void init() {
        if (!this.m_initialized) {
            this.initSynchronized();
            this.m_initialized = true;
        }
    }

    protected synchronized void initSynchronized() {
        if (this.m_initialized || !this.m_active) {
            return;
        }
        this.m_httpRequestInitializer = this.createHttpRequestInitializer();
        this.m_httpTransport = this.createHttpTransport();
        this.m_httpRequestFactory = this.m_httpTransport.createRequestFactory(this.getHttpRequestInitializer());
    }

    protected HttpRequestInitializer createHttpRequestInitializer() {
        return new DefaultHttpRequestInitializer();
    }

    protected HttpTransport createHttpTransport() {
        return ((IHttpTransportFactory)BEANS.get(this.getHttpTransportFactory())).newHttpTransport(this);
    }

    @Override
    public void interceptNewHttpTransport(IHttpTransportBuilder builder) {
    }

    protected Class<? extends IHttpTransportFactory> getHttpTransportFactory() {
        return (Class)CONFIG.getPropertyValue(HttpTransportFactoryProperty.class);
    }

    protected HttpRequestInitializer getHttpRequestInitializer() {
        return this.m_httpRequestInitializer;
    }

    public void stateChanged(PlatformEvent event) {
        if (event.getState() == IPlatform.State.PlatformStopping && this.m_httpTransport != null) {
            this.removeHttpTransport();
        }
    }

    protected synchronized void removeHttpTransport() {
        if (this.m_httpTransport == null) {
            return;
        }
        try {
            try {
                this.m_httpTransport.shutdown();
            }
            catch (IOException e) {
                throw new ProcessingException("Error during HttpTransport shut down.", new Object[]{e});
            }
        }
        finally {
            this.m_active = false;
            this.m_httpTransport = null;
        }
    }

    public byte[] readFromUrl(URL url) throws IOException {
        GenericUrl genericUrl = new GenericUrl(url);
        HttpRequest req = this.getHttpRequestFactory().buildGetRequest(genericUrl);
        HttpResponse resp = req.execute();
        Long contentLength = resp.getHeaders().getContentLength();
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedInputStream in = new BufferedInputStream(resp.getContent());){
            return IOUtility.readBytes((InputStream)in, (int)(contentLength != null ? contentLength.intValue() : -1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class DefaultHttpRequestInitializer
    implements HttpRequestInitializer,
    HttpIOExceptionHandler {
        public void initialize(HttpRequest request) throws IOException {
            request.setReadTimeout(0);
            request.setThrowExceptionOnExecuteError(false);
            request.setIOExceptionHandler((HttpIOExceptionHandler)this);
        }

        public boolean handleIOException(HttpRequest request, boolean supportsRetry) {
            return true;
        }
    }
}

