/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;

@Bean
public abstract class AbstractMultiSessionCookieStore<CS> {
    private final ReadWriteLock m_cookieStoresLock = new ReentrantReadWriteLock();
    private final Map<ISession, CS> m_cookieStores = new WeakHashMap<ISession, CS>();
    private final CS m_defaultCookieStore = this.createDefaultCookieStore();

    protected abstract CS createDefaultCookieStore();

    protected abstract CS createNewCookieStore();

    protected CS getDelegate() {
        CS cookieStore;
        ISession currentSession = ISession.CURRENT.get();
        if (currentSession == null) {
            return this.m_defaultCookieStore;
        }
        this.m_cookieStoresLock.readLock().lock();
        try {
            cookieStore = this.m_cookieStores.get(currentSession);
            if (cookieStore != null) {
                CS CS = cookieStore;
                return CS;
            }
        }
        finally {
            this.m_cookieStoresLock.readLock().unlock();
        }
        this.m_cookieStoresLock.writeLock().lock();
        try {
            cookieStore = this.m_cookieStores.get(currentSession);
            if (cookieStore != null) {
                CS CS = cookieStore;
                return CS;
            }
            cookieStore = this.createNewCookieStore();
            this.m_cookieStores.put(currentSession, cookieStore);
            currentSession.addListener(new P_SessionStoppedListenr());
            CS CS = cookieStore;
            return CS;
        }
        finally {
            this.m_cookieStoresLock.writeLock().unlock();
        }
    }

    public void sessionStopped(ISession session) {
        this.m_cookieStoresLock.writeLock().lock();
        try {
            this.m_cookieStores.remove(session);
        }
        finally {
            this.m_cookieStoresLock.writeLock().unlock();
        }
    }

    private class P_SessionStoppedListenr
    implements ISessionListener {
        private P_SessionStoppedListenr() {
        }

        @Override
        public void sessionChanged(SessionEvent event) {
            if (110 == event.getType()) {
                ISession session = event.getSource();
                AbstractMultiSessionCookieStore.this.sessionStopped(session);
                session.removeListener(this);
            }
        }
    }
}

