/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http;

import com.google.api.client.http.HttpTransport;
import java.net.ProxySelector;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.http.ApacheMultiSessionCookieStore;
import org.eclipse.scout.rt.shared.http.EnhancedLaxRedirectStrategy;
import org.eclipse.scout.rt.shared.http.HttpConfigurationProperties;
import org.eclipse.scout.rt.shared.http.IHttpTransportBuilder;
import org.eclipse.scout.rt.shared.http.IHttpTransportFactory;
import org.eclipse.scout.rt.shared.http.IHttpTransportManager;
import org.eclipse.scout.rt.shared.http.proxy.ConfigurableProxySelector;
import org.eclipse.scout.rt.shared.http.retry.CustomHttpRequestRetryHandler;
import org.eclipse.scout.rt.shared.http.transport.ApacheHttpTransport;

public class ApacheHttpTransportFactory
implements IHttpTransportFactory {
    @Override
    public HttpTransport newHttpTransport(IHttpTransportManager manager) {
        HttpClientBuilder builder = HttpClients.custom();
        this.installConfigurableProxySelector(builder);
        this.installMultiSessionCookieStore(builder);
        this.setConnectionKeepAliveAndRetrySettings(builder);
        HttpClientConnectionManager cm = this.createHttpClientConnectionManager();
        if (cm != null) {
            builder.setConnectionManager(cm);
        }
        this.interceptNewHttpTransport(builder, manager);
        manager.interceptNewHttpTransport(new ApacheHttpTransportBuilder(builder, cm));
        return new ApacheHttpTransport((HttpClient)builder.build());
    }

    protected void setConnectionKeepAliveAndRetrySettings(HttpClientBuilder builder) {
        this.addConnectionKeepAliveSettings(builder);
        this.addRetrySettings(builder);
        this.addRedirectSettings(builder);
    }

    protected void addConnectionKeepAliveSettings(HttpClientBuilder builder) {
        boolean keepAliveProp = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportKeepAliveProperty.class);
        if (keepAliveProp) {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
        } else {
            builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        }
    }

    protected void addRetrySettings(HttpClientBuilder builder) {
        boolean retryOnNoHttpResponseException = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnNoHttpResponseExceptionProperty.class);
        boolean retryOnSocketExceptionByConnectionReset = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRetryOnSocketExceptionByConnectionResetProperty.class);
        if (retryOnNoHttpResponseException || retryOnSocketExceptionByConnectionReset) {
            builder.setRetryHandler((HttpRequestRetryHandler)new CustomHttpRequestRetryHandler(1, false, retryOnNoHttpResponseException, retryOnSocketExceptionByConnectionReset));
        } else {
            builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false));
        }
    }

    protected void addRedirectSettings(HttpClientBuilder builder) {
        boolean redirectPost = (Boolean)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportRedirectPostProperty.class);
        if (redirectPost) {
            builder.setRedirectStrategy((RedirectStrategy)EnhancedLaxRedirectStrategy.INSTANCE);
        } else {
            builder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
        }
    }

    protected HttpClientConnectionManager createHttpClientConnectionManager() {
        Integer defaultMaxPerRoute;
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)this.createPlainSocketFactory()).register("https", (Object)this.createSSLConnectionSocketFactory()).build(), null, null, null, (long)((Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportConnectionTimeToLiveProperty.class)).intValue(), TimeUnit.MILLISECONDS);
        connectionManager.setValidateAfterInactivity(1);
        Integer maxTotal = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsTotalProperty.class);
        if (maxTotal != null && maxTotal > 0) {
            connectionManager.setMaxTotal(maxTotal.intValue());
        }
        if ((defaultMaxPerRoute = (Integer)CONFIG.getPropertyValue(HttpConfigurationProperties.ApacheHttpTransportMaxConnectionsPerRouteProperty.class)) > 0) {
            connectionManager.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
        }
        return connectionManager;
    }

    protected SSLConnectionSocketFactory createSSLConnectionSocketFactory() {
        String[] sslProtocols = StringUtility.split((String)System.getProperty("https.protocols"), (String)"\\s*,\\s*");
        String[] sslCipherSuites = StringUtility.split((String)System.getProperty("https.cipherSuites"), (String)"\\s*,\\s*");
        return new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), sslProtocols != null && sslProtocols.length > 0 ? sslProtocols : null, sslCipherSuites != null && sslCipherSuites.length > 0 ? sslCipherSuites : null, (HostnameVerifier)new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault()));
    }

    protected PlainConnectionSocketFactory createPlainSocketFactory() {
        return PlainConnectionSocketFactory.getSocketFactory();
    }

    protected void installConfigurableProxySelector(HttpClientBuilder builder) {
        builder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((ProxySelector)BEANS.get(ConfigurableProxySelector.class)));
    }

    protected void installMultiSessionCookieStore(HttpClientBuilder builder) {
        builder.setDefaultCookieStore((CookieStore)BEANS.get(ApacheMultiSessionCookieStore.class));
    }

    protected void interceptNewHttpTransport(HttpClientBuilder builder, IHttpTransportManager manager) {
    }

    public static class ApacheHttpTransportBuilder
    implements IHttpTransportBuilder {
        private final HttpClientBuilder m_builder;
        private final HttpClientConnectionManager m_connectionManager;

        public ApacheHttpTransportBuilder(HttpClientBuilder builder, HttpClientConnectionManager connectionManager) {
            this.m_builder = builder;
            this.m_connectionManager = connectionManager;
        }

        public HttpClientBuilder getBuilder() {
            return this.m_builder;
        }

        public HttpClientConnectionManager getConnectionManager() {
            return this.m_connectionManager;
        }
    }
}

