/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.http.retry;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.eclipse.scout.rt.shared.http.retry.OneTimeRepeatableRequestEntityProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CustomHttpRequestRetryHandler.class);
    private final Set<Class<? extends IOException>> m_nonRetriableClasses;
    private final boolean m_retryOnNoHttpResponseException;
    private final boolean m_retryOnSocketExceptionByConnectionReset;

    public CustomHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled, boolean retryOnNoHttpResponseException, boolean retryOnSocketExceptionByConnectionReset) {
        this(retryCount, requestSentRetryEnabled, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class), retryOnNoHttpResponseException, retryOnSocketExceptionByConnectionReset);
    }

    protected CustomHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled, Collection<Class<? extends IOException>> clazzes, boolean retryOnNoHttpResponseException, boolean retryOnSocketExceptionByConnectionReset) {
        super(retryCount, requestSentRetryEnabled, clazzes);
        this.m_nonRetriableClasses = new HashSet<Class<? extends IOException>>(clazzes);
        this.m_retryOnNoHttpResponseException = retryOnNoHttpResponseException;
        this.m_retryOnSocketExceptionByConnectionReset = retryOnSocketExceptionByConnectionReset;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (executionCount > this.getRetryCount()) {
            return false;
        }
        if (this.m_nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.m_nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            return false;
        }
        if (this.handleAsIdempotent(request)) {
            return true;
        }
        if (!clientContext.isRequestSent() || this.isRequestSentRetryEnabled()) {
            return true;
        }
        return this.detectStaleSocketChannel(exception, (HttpContext)clientContext);
    }

    protected boolean detectStaleSocketChannel(IOException exception, HttpContext context) {
        boolean retry;
        String message;
        if (this.m_retryOnNoHttpResponseException && exception instanceof NoHttpResponseException) {
            message = "detected a 'NoHttpResponseException', assuming a stale socket channel; retry non-idempotent request";
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug(message);
            } else {
                LOG.warn(message);
            }
            retry = true;
        } else if (this.m_retryOnSocketExceptionByConnectionReset && exception instanceof SocketException && "Connection reset".equals(exception.getMessage())) {
            message = "detected a 'SocketException: Connection reset', assuming a stale socket channel; retry non-idempotent request";
            if (Thread.currentThread().isInterrupted()) {
                LOG.debug(message);
            } else {
                LOG.warn(message);
            }
            retry = true;
        } else {
            retry = false;
        }
        if (retry) {
            HttpRequest request = HttpClientContext.adapt((HttpContext)context).getRequest();
            OneTimeRepeatableRequestEntityProxy.installRetry(request);
        }
        return retry;
    }
}

