/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.RecurrencePattern;

public abstract class AbstractCalendarItem
implements ICalendarItem,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean m_exists = true;
    private long m_lastModified;
    private Object m_itemId;
    private String m_owner;
    private String m_subject;
    private String m_body;
    private String m_cssClass;
    private RecurrencePattern m_recurrencyPattern;
    private Serializable m_externalKey;

    public static DateFormat getDumpDateFormat() {
        return new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    }

    public static DateFormat getExchangeableDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    public AbstractCalendarItem() {
        this(0L);
    }

    public AbstractCalendarItem(Object id) {
        this.m_itemId = id;
    }

    public ICalendarItem copy() {
        Class<?> c = this.getClass();
        try {
            AbstractCalendarItem a = (AbstractCalendarItem)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            a.m_exists = this.m_exists;
            a.m_lastModified = this.m_lastModified;
            a.m_itemId = this.m_itemId;
            a.m_owner = this.m_owner;
            a.m_subject = this.m_subject;
            a.m_body = this.m_body;
            a.m_cssClass = this.m_cssClass;
            a.m_recurrencyPattern = this.m_recurrencyPattern;
            return a;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getCssClass() {
        return this.m_cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.m_cssClass = cssClass;
    }

    @Override
    public boolean exists() {
        return this.m_exists;
    }

    @Override
    public void delete() {
        this.m_exists = false;
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public void setLastModified(long b) {
        this.m_lastModified = b;
    }

    @Override
    public Object getItemId() {
        return this.m_itemId;
    }

    @Override
    public void setItemId(Object itemId) {
        this.m_itemId = itemId;
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(String a) {
        this.m_owner = a;
    }

    @Override
    public String getSubject() {
        return this.m_subject;
    }

    @Override
    public void setSubject(String a) {
        this.m_subject = a;
    }

    @Override
    public String getBody() {
        return this.m_body;
    }

    @Override
    public void setBody(String a) {
        this.m_body = a;
    }

    @Override
    public RecurrencePattern getRecurrencePattern() {
        return this.m_recurrencyPattern;
    }

    @Override
    public void setRecurrencePattern(RecurrencePattern p) {
        this.m_recurrencyPattern = p;
    }

    protected void dumpState(Map<String, Object> attributes) {
        attributes.put("exists", this.m_exists);
        attributes.put("lastModified", AbstractCalendarItem.getDumpDateFormat().format(this.m_lastModified));
        attributes.put("id", String.valueOf(this.m_itemId));
        attributes.put("owner", this.m_owner);
        attributes.put("subject", this.m_subject);
        if (this.m_body != null) {
            attributes.put("body", this.m_body.replace('\n', ' ').replace('\r', ' ').substring(0, Math.min(200, this.m_body.length())));
        }
        attributes.put("recurrencyPattern", this.m_recurrencyPattern);
    }

    @Override
    public Serializable getExternalKey() {
        return this.m_externalKey;
    }

    @Override
    public void setExternalKey(Serializable externalKey) {
        this.m_externalKey = externalKey;
    }

    @Override
    public String getDescription() {
        return this.m_body;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.dumpState(attributes);
        int count = 0;
        for (Map.Entry e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            if (count > 0) {
                b.append(", ");
            }
            b.append((String)e.getKey()).append("=").append(e.getValue());
            ++count;
        }
        b.append("]");
        return b.toString();
    }
}

