/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressedReader
extends Reader {
    private static final Logger LOG = LoggerFactory.getLogger(DecompressedReader.class);
    private final RemoteFile m_remoteFile;
    private final ByteArrayInputStream m_buffer;
    private final Inflater m_inflater;
    private final InflaterInputStream m_inflaterInputStream;
    private InputStreamReader m_inputReader;

    public DecompressedReader(RemoteFile f) {
        this(f, StandardCharsets.UTF_8.name());
    }

    public DecompressedReader(RemoteFile f, String charsetName) {
        this.m_remoteFile = f;
        this.m_buffer = new ByteArrayInputStream(this.m_remoteFile.getCompressedData());
        this.m_inflater = new Inflater();
        this.m_inflaterInputStream = new InflaterInputStream(this.m_buffer, this.m_inflater);
        try {
            this.m_inputReader = new InputStreamReader((InputStream)this.m_inflaterInputStream, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("unsupporeted encoding '{}'", (Object)charsetName, (Object)e);
            this.m_inputReader = new InputStreamReader(this.m_inflaterInputStream);
        }
    }

    @Override
    public void close() throws IOException {
        this.m_inputReader.close();
        this.m_inflaterInputStream.close();
        this.m_inflater.end();
        this.m_buffer.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.m_inputReader.read(cbuf, off, len);
    }
}

