/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;

public class SearchFilter
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean m_completed;
    private AbstractFormData m_formData;
    private List<String> m_displayTexts;

    public SearchFilter() {
        this.m_displayTexts = new ArrayList<String>();
    }

    protected SearchFilter(SearchFilter other) {
        this.m_completed = other.m_completed;
        if (other.m_formData != null) {
            this.m_formData = other.m_formData.deepCopy();
        }
        this.m_displayTexts = new ArrayList<String>(other.m_displayTexts);
    }

    public AbstractFormData getFormData() {
        return this.m_formData;
    }

    public void setFormData(AbstractFormData formData) {
        this.m_formData = formData;
    }

    public void addDisplayText(String s) {
        this.m_displayTexts.add(s);
    }

    public void clear() {
        this.m_completed = false;
        this.m_displayTexts.clear();
        this.m_formData = null;
    }

    public String[] getDisplayTexts() {
        return this.m_displayTexts.toArray(new String[0]);
    }

    public void setDisplayTexts(String[] displayTexts) {
        this.m_displayTexts = CollectionUtility.arrayList((Object[])displayTexts);
    }

    public String getDisplayTextsPlain() {
        StringBuilder buf = new StringBuilder();
        char nl = '\n';
        String[] stringArray = this.getDisplayTexts();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                buf.append(s.trim());
                buf.append(nl);
            }
            ++n2;
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == nl) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public boolean isCompleted() {
        return this.m_completed;
    }

    public void setCompleted(boolean b) {
        this.m_completed = b;
    }

    public SearchFilter copy() {
        return new SearchFilter(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('[');
        if (this.m_formData != null) {
            buf.append(this.m_formData.toString());
        }
        buf.append(']');
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_completed ? 1231 : 1237);
        result = 31 * result + (this.m_displayTexts == null ? 0 : this.m_displayTexts.hashCode());
        result = 31 * result + (this.m_formData == null ? 0 : this.m_formData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchFilter other = (SearchFilter)obj;
        if (this.m_completed != other.m_completed) {
            return false;
        }
        if (this.m_displayTexts == null ? other.m_displayTexts != null : !this.m_displayTexts.equals(other.m_displayTexts)) {
            return false;
        }
        return !(this.m_formData == null ? other.m_formData != null : !this.m_formData.equals(other.m_formData));
    }
}

