/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.text.dev;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.text.ITextProviderService;
import org.eclipse.scout.rt.platform.text.ScoutTexts;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreBean
public class TextKeyTextProviderService
implements ITextProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(TextKeyTextProviderService.class);

    public String getText(Locale locale, String key, String ... messageArguments) {
        return "${textKey:" + key + "}";
    }

    public Map<String, String> getTextMap(Locale locale) {
        return Collections.emptyMap();
    }

    public static void register() {
        LOG.info("Register TextKeyTextProviderService with high priority. ScoutTexts will return text keys instead of localized texts");
        BeanMetaData beanData = new BeanMetaData(TextKeyTextProviderService.class).withOrder(1.0);
        Platform.get().getBeanManager().registerBean(beanData);
        ((ScoutTexts)BEANS.get(ScoutTexts.class)).reloadTextProviders();
    }

    public static void unregister() {
        LOG.info("Unregistered TextKeyTextProviderService. ScoutTexts will work as usual");
        Platform.get().getBeanManager().unregisterClass(TextKeyTextProviderService.class);
        ((ScoutTexts)BEANS.get(ScoutTexts.class)).reloadTextProviders();
    }

    public static class P_Initializer
    implements IPlatformListener {
        public void stateChanged(PlatformEvent event) {
            if (IPlatform.State.PlatformStarted == event.getState() && ((Boolean)CONFIG.getPropertyValue(SharedConfigProperties.DevTextProvidersShowKeysProperty.class)).booleanValue()) {
                TextKeyTextProviderService.register();
            }
        }
    }
}

