/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallFactoryService;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@IgnoreBean
@ClassId(value="bf3702b8-ee95-4c7b-870d-105b9d0deec2")
public class CodeLookupCall<CODE_ID>
extends LocalLookupCall<CODE_ID> {
    private static final long serialVersionUID = 0L;
    private final Class<? extends ICodeType<?, CODE_ID>> m_codeTypeClass;
    private ICodeLookupCallVisitor<CODE_ID> m_filter;
    private Comparator<ILookupRow<CODE_ID>> m_sortComparator;

    public static <T> CodeLookupCall<T> newInstanceByService(Class<? extends ICodeType<?, T>> codeTypeClass) {
        return ((ICodeLookupCallFactoryService)BEANS.get(ICodeLookupCallFactoryService.class)).newInstance(codeTypeClass);
    }

    public CodeLookupCall(Class<? extends ICodeType<?, CODE_ID>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
    }

    public Comparator<ILookupRow<CODE_ID>> getSortComparator() {
        return this.m_sortComparator;
    }

    public void setSortComparator(Comparator<ILookupRow<CODE_ID>> comp) {
        this.m_sortComparator = comp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_codeTypeClass == null ? 0 : this.m_codeTypeClass.hashCode());
        result = 31 * result + (this.m_filter == null ? 0 : this.m_filter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeLookupCall other = (CodeLookupCall)obj;
        if (this.m_codeTypeClass == null ? other.m_codeTypeClass != null : !this.m_codeTypeClass.equals(other.m_codeTypeClass)) {
            return false;
        }
        return !(this.m_filter == null ? other.m_filter != null : !this.m_filter.equals(other.m_filter));
    }

    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setFilter(ICodeLookupCallVisitor<CODE_ID> filter) {
        this.m_filter = filter;
    }

    public ICodeLookupCallVisitor getFilter() {
        return this.m_filter;
    }

    protected List<ILookupRow<CODE_ID>> execCreateLookupRowsFromCodes(List<? extends ICode<CODE_ID>> codes) {
        ArrayList<ILookupRow<CODE_ID>> a = new ArrayList<ILookupRow<CODE_ID>>(codes.size());
        for (ICode<CODE_ID> c : codes) {
            a.add(this.execCreateLookupRowFromCode(c));
        }
        return a;
    }

    protected ILookupRow<CODE_ID> execCreateLookupRowFromCode(ICode<CODE_ID> c) {
        return this.createCodeLookupRow(c);
    }

    protected <T> List<ILookupRow<T>> createCodeLookupRowList(List<? extends ICode<T>> codes) {
        ArrayList<ILookupRow<T>> rows = new ArrayList<ILookupRow<T>>(codes.size());
        for (ICode<T> code : codes) {
            rows.add(this.createCodeLookupRow(code));
        }
        return rows;
    }

    protected <T> ILookupRow<T> createCodeLookupRow(ICode<T> c) {
        return ((LookupRow)((LookupRow)((LookupRow)((LookupRow)((LookupRow)((LookupRow)((LookupRow)((LookupRow)new LookupRow<T>(c.getId(), c.getText()).withIconId(c.getIconId())).withTooltipText(c.getTooltipText())).withBackgroundColor(c.getBackgroundColor())).withForegroundColor(c.getForegroundColor())).withFont(c.getFont())).withCssClass(c.getCssClass())).withEnabled(c.isEnabled())).withParentKey((Object)(c.getParentCode() != null ? c.getParentCode().getId() : null))).withActive(c.isActive());
    }

    @Override
    protected Pattern createSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        s = s.replace(this.getWildcard(), "@wildcard@");
        s = s.toLowerCase();
        s = StringUtility.escapeRegexMetachars((CharSequence)s);
        if (!(s = s.replace("@wildcard@", ".*")).endsWith(".*")) {
            s = String.valueOf(s) + ".*";
        }
        return Pattern.compile(s, 32);
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByKey() {
        ArrayList<ICode<CODE_ID>> list = new ArrayList<ICode<CODE_ID>>(1);
        ICode<CODE_ID> c = this.resolveCodeByKey();
        if (c != null) {
            list.add(c);
        }
        return this.execCreateLookupRowsFromCodes(list);
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByText() {
        final Pattern pat = this.createSearchPattern(this.getText());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            protected ILookupRow<CODE_ID> toLookupRow(ICode<CODE_ID> code) {
                ILookupRow row = this.execCreateLookupRowFromCode(code);
                if (row != null && row.getText() != null && (pat.matcher(row.getText().toLowerCase()).matches() || this.isHierarchicalLookup() && this.isParentInResultList(this.m_list, row))) {
                    return row;
                }
                return null;
            }
        };
        this.resolveCodes(v);
        return v.getLookupRows();
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByAll() {
        final Pattern pat = this.createSearchPattern(this.getAll());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            protected ILookupRow<CODE_ID> toLookupRow(ICode<CODE_ID> code) {
                ILookupRow row = this.execCreateLookupRowFromCode(code);
                if (row != null && row.getText() != null && pat.matcher(row.getText().toLowerCase()).matches()) {
                    return row;
                }
                return null;
            }
        };
        this.resolveCodes(v);
        return v.getLookupRows();
    }

    @Override
    public List<ILookupRow<CODE_ID>> getDataByRec() {
        Object recValue = this.getRec();
        if (recValue instanceof Number && ((Number)recValue).longValue() == 0L) {
            recValue = null;
        }
        final Object key = recValue;
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(this){

            @Override
            protected ILookupRow<CODE_ID> toLookupRow(ICode<CODE_ID> code) {
                ICode parentCode = code.getParentCode();
                if (parentCode == null && key == null || parentCode != null && parentCode.getId() != null && parentCode.getId().equals(key)) {
                    return this.execCreateLookupRowFromCode(code);
                }
                return null;
            }
        };
        this.resolveCodes(v);
        return v.getLookupRows();
    }

    protected ICode<CODE_ID> resolveCodeByKey() {
        Object key = this.getKey();
        ICodeType t = (ICodeType)BEANS.opt(this.m_codeTypeClass);
        if (t == null) {
            return null;
        }
        return t.getCode(key);
    }

    protected void resolveCodes(ICodeVisitor<ICode<CODE_ID>> v) {
        ICodeType t = (ICodeType)BEANS.opt(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
    }

    protected abstract class AbstractLookupRowCollector
    implements ICodeVisitor<ICode<CODE_ID>> {
        protected final List<ILookupRow<CODE_ID>> m_list = new ArrayList();

        protected AbstractLookupRowCollector() {
        }

        @Override
        public boolean visit(ICode<CODE_ID> code, int treeLevel) {
            ILookupRow row;
            if (!this.acceptedByRowCount()) {
                return false;
            }
            if (!this.acceptedByFilter(code, treeLevel)) {
                return true;
            }
            if (this.acceptedByActive(code, treeLevel) && (row = this.toLookupRow(code)) != null) {
                this.m_list.add(row);
            }
            return true;
        }

        protected boolean acceptedByActive(ICode<CODE_ID> code, int treeLevel) {
            return CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive();
        }

        protected boolean acceptedByRowCount() {
            return CodeLookupCall.this.getMaxRowCount() < 1 || this.m_list.size() <= CodeLookupCall.this.getMaxRowCount();
        }

        protected boolean acceptedByFilter(ICode<CODE_ID> code, int treeLevel) {
            return CodeLookupCall.this.m_filter == null || CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel);
        }

        protected abstract ILookupRow<CODE_ID> toLookupRow(ICode<CODE_ID> var1);

        public List<ILookupRow<CODE_ID>> getLookupRows() {
            Comparator comparator;
            if (this.m_list.size() > 1 && (comparator = CodeLookupCall.this.getSortComparator()) != null) {
                this.m_list.sort(comparator);
            }
            return this.m_list;
        }
    }
}

