/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

@ClassId(value="6a7d238a-11ab-478b-a3fb-7a99494b711d")
public class LocalLookupCall<T>
extends LookupCall<T> {
    private static final long serialVersionUID = 0L;
    private boolean m_hierarchicalLookup;
    private static final String WILDCARD_PLACEHOLDER = "@wildcard@";

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @ConfigOperation
    @Order(value=30.0)
    protected List<? extends ILookupRow<T>> execCreateLookupRows() {
        return null;
    }

    protected List<? extends ILookupRow<T>> interceptCreateLookupRows() {
        return this.execCreateLookupRows();
    }

    protected List<? extends ILookupRow<T>> createLookupRowsFiltered() {
        return this.filterActiveLookupRows(this.interceptCreateLookupRows());
    }

    protected List<? extends ILookupRow<T>> filterActiveLookupRows(List<? extends ILookupRow<T>> allRows) {
        TriState lookupCallActive0 = this.getActive();
        if (TriState.UNDEFINED == lookupCallActive0) {
            return allRows;
        }
        boolean lookupCallActive = BooleanUtility.nvl((Boolean)lookupCallActive0.getBooleanValue());
        return allRows.stream().filter(row -> row.isActive() == lookupCallActive).collect(Collectors.toList());
    }

    protected Pattern createSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        s = s.replace(this.getWildcard(), WILDCARD_PLACEHOLDER);
        s = s.toLowerCase();
        s = StringUtility.escapeRegexMetachars((CharSequence)s);
        String duplicateWildcards = WILDCARD_PLACEHOLDER.concat(WILDCARD_PLACEHOLDER);
        while (s.contains(duplicateWildcards)) {
            s = s.replace(duplicateWildcards, WILDCARD_PLACEHOLDER);
        }
        if (!s.contains(WILDCARD_PLACEHOLDER)) {
            s = s.concat(WILDCARD_PLACEHOLDER);
        }
        s = s.replace(WILDCARD_PLACEHOLDER, ".*");
        return Pattern.compile(s, 32);
    }

    @Override
    protected final Class<? extends ILookupService<T>> getConfiguredService() {
        return null;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByKey() {
        if (this.getKey() == null) {
            return CollectionUtility.emptyArrayList();
        }
        Object key = this.getKey();
        List<ILookupRow<T>> rows = this.interceptCreateLookupRows();
        if (rows == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>(rows.size());
        for (ILookupRow<T> row : rows) {
            if (!key.equals(row.getKey())) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByText() {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Pattern p = this.createSearchPattern(this.getText());
        List<ILookupRow<T>> lookupRows = this.createLookupRowsFiltered();
        for (ILookupRow<T> row : lookupRows) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        if (this.isHierarchicalLookup()) {
            Map<T, Set<ILookupRow<T>>> nodeMap = this.createNodeMap(lookupRows);
            ArrayList<ILookupRow<T>> children = new ArrayList<ILookupRow<T>>();
            for (ILookupRow iLookupRow : list) {
                this.collectChildrenRec(nodeMap, iLookupRow.getKey(), children);
            }
            list.addAll(children);
        }
        return list;
    }

    protected Map<T, Set<ILookupRow<T>>> createNodeMap(List<? extends ILookupRow<T>> lookupRows) {
        HashMap<Object, Set> nodeMap = new HashMap<Object, Set>();
        for (ILookupRow<T> row : lookupRows) {
            Set node = nodeMap.computeIfAbsent(row.getParentKey(), k -> new HashSet());
            node.add(row);
        }
        return nodeMap;
    }

    protected void collectChildrenRec(Map<T, Set<ILookupRow<T>>> nodeMap, T key, List<ILookupRow<T>> children) {
        if (nodeMap.get(key) == null) {
            return;
        }
        for (ILookupRow<T> var : nodeMap.get(key)) {
            children.add(var);
            this.collectChildrenRec(nodeMap, var.getKey(), children);
        }
    }

    protected boolean isParentInResultList(List<ILookupRow<T>> result, ILookupRow<T> row) {
        return this.getLookupRowWithKey(result, row.getParentKey()) != null && !result.contains(row);
    }

    protected ILookupRow<T> getLookupRowWithKey(List<ILookupRow<T>> result, T key) {
        for (ILookupRow<T> row : result) {
            if (!row.getKey().equals(key)) continue;
            return row;
        }
        return null;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByAll() {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Pattern p = this.createSearchPattern(this.getAll());
        for (ILookupRow<T> row : this.createLookupRowsFiltered()) {
            if (row.getText() == null || !p.matcher(row.getText().toLowerCase()).matches()) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public List<? extends ILookupRow<T>> getDataByRec() {
        ArrayList<ILookupRow<T>> list = new ArrayList<ILookupRow<T>>();
        Object parentKey = this.getRec();
        if (parentKey == null) {
            for (ILookupRow<T> row : this.createLookupRowsFiltered()) {
                if (row.getParentKey() != null) continue;
                list.add(row);
            }
        } else {
            for (ILookupRow<T> row : this.createLookupRowsFiltered()) {
                if (!parentKey.equals(row.getParentKey())) continue;
                list.add(row);
            }
        }
        return list;
    }

    public boolean isHierarchicalLookup() {
        return this.m_hierarchicalLookup;
    }

    public void setHierarchicalLookup(boolean hierarchicalLookup) {
        this.m_hierarchicalLookup = hierarchicalLookup;
    }
}

