/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.MemoryOptimizedObject;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupRow<ID_TYPE>
extends MemoryOptimizedObject
implements ILookupRow<ID_TYPE> {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(LookupRow.class);
    public static final LookupRow<?>[] EMPTY_ARRAY = new LookupRow[0];
    public static final int KEY_BIT = 1;
    public static final int TEXT_BIT = 2;
    public static final int ICON_ID_BIT = 3;
    public static final int TOOLTIP_BIT = 4;
    public static final int BACKGROUD_COLOR_BIT = 5;
    public static final int FOREGROUD_COLOR_BIT = 6;
    public static final int FONT_BIT = 7;
    public static final int ENABLED_BIT = 8;
    public static final int PARENT_KEY_BIT = 9;
    public static final int ACTIVE_BIT = 10;
    public static final int ADDITIONAL_TABLE_ROW_DATA = 11;
    public static final int CSS_CLASS_BIT = 12;

    public LookupRow(ID_TYPE key, String text) {
        ((LookupRow)this.withKey((Object)key)).withText(text);
    }

    public LookupRow(Object[] cells, Class<?> keyClass) {
        this(cells, cells == null ? -1 : cells.length - 1, keyClass);
    }

    public LookupRow(Object[] cells, int maxColumnIndex, Class<?> keyClass) {
        if (cells != null) {
            if (maxColumnIndex > cells.length - 1) {
                LOG.warn("Max column index ({}) greater than provided data ({}).", (Object)maxColumnIndex, (Object)(cells.length - 1));
                maxColumnIndex = cells.length - 1;
            }
            int keyIndex = 0;
            int textIndex = 1;
            int iconIndex = 2;
            int ttIndex = 3;
            int bgIndex = 4;
            int fgIndex = 5;
            int fontIndex = 6;
            int enabledIndex = 7;
            int parentKeyIndex = 8;
            int activeIndex = 9;
            if (keyIndex <= maxColumnIndex && cells[keyIndex] != null) {
                Object key = cells[keyIndex];
                this.assertAssignableFrom(key, keyClass);
                this.withKey(key);
            }
            if (textIndex <= maxColumnIndex && cells[textIndex] != null) {
                this.withText(cells[textIndex].toString());
            }
            if (iconIndex <= maxColumnIndex && cells[iconIndex] != null) {
                this.withIconId(cells[iconIndex].toString());
            }
            if (ttIndex <= maxColumnIndex && cells[ttIndex] != null) {
                this.withTooltipText(cells[ttIndex].toString());
            }
            if (bgIndex <= maxColumnIndex && cells[bgIndex] != null) {
                this.withBackgroundColor(cells[bgIndex].toString());
            }
            if (fgIndex <= maxColumnIndex && cells[fgIndex] != null) {
                this.withForegroundColor(cells[fgIndex].toString());
            }
            if (fontIndex <= maxColumnIndex && cells[fontIndex] != null) {
                this.withFont(cells[fontIndex].toString());
            }
            if (enabledIndex <= maxColumnIndex && cells[enabledIndex] != null) {
                if (cells[enabledIndex] instanceof Boolean) {
                    this.withEnabled((Boolean)cells[enabledIndex]);
                } else if (cells[enabledIndex] instanceof Number) {
                    this.withEnabled(((Number)cells[enabledIndex]).intValue() != 0);
                } else {
                    LOG.error("Ignoring invalid Boolean value '{}'", cells[enabledIndex]);
                }
            }
            if (parentKeyIndex <= maxColumnIndex && cells[parentKeyIndex] != null) {
                Object parentKey = cells[parentKeyIndex];
                this.assertAssignableFrom(parentKey, keyClass);
                this.withParentKey(parentKey);
            }
            if (activeIndex <= maxColumnIndex && cells[activeIndex] != null) {
                if (cells[activeIndex] instanceof Boolean) {
                    this.withActive((Boolean)cells[activeIndex]);
                } else if (cells[activeIndex] instanceof Number) {
                    this.withActive(((Number)cells[activeIndex]).intValue() != 0);
                } else {
                    LOG.error("Ignoring invalid Boolean value '{}'", cells[activeIndex]);
                }
            }
        }
    }

    private <T> T assertAssignableFrom(Object object, Class<T> clazz) {
        if (clazz != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Invalid key type for LookupRow. Expected: '" + clazz.getName() + "', actual: '" + object.getClass().getName() + "'.");
        }
        return (T)object;
    }

    @Override
    public ID_TYPE getKey() {
        return (ID_TYPE)this.getValueInternal(1);
    }

    @Override
    public LookupRow<ID_TYPE> withKey(ID_TYPE key) {
        this.setValueInternal(1, key);
        return this;
    }

    @Override
    public ID_TYPE getParentKey() {
        return (ID_TYPE)this.getValueInternal(9);
    }

    @Override
    public LookupRow<ID_TYPE> withParentKey(ID_TYPE parentKey) {
        this.setValueInternal(9, parentKey);
        return this;
    }

    @Override
    public String getText() {
        char[] c = (char[])this.getValueInternal(2);
        return c != null ? new String(c) : null;
    }

    @Override
    public LookupRow<ID_TYPE> withText(String text) {
        this.setValueInternal(2, text != null ? text.toCharArray() : null);
        return this;
    }

    @Override
    public String getIconId() {
        return (String)this.getValueInternal(3);
    }

    @Override
    public LookupRow<ID_TYPE> withIconId(String iconId) {
        this.setValueInternal(3, StringUtility.intern((String)iconId));
        return this;
    }

    @Override
    public String getTooltipText() {
        char[] c = (char[])this.getValueInternal(4);
        return c != null ? new String(c) : null;
    }

    @Override
    public LookupRow<ID_TYPE> withTooltipText(String tooltipText) {
        this.setValueInternal(4, tooltipText != null ? tooltipText.toCharArray() : null);
        return this;
    }

    @Override
    public String getForegroundColor() {
        return (String)this.getValueInternal(6);
    }

    @Override
    public LookupRow<ID_TYPE> withForegroundColor(String foregroundColor) {
        this.setValueInternal(6, StringUtility.intern((String)foregroundColor));
        return this;
    }

    @Override
    public String getCssClass() {
        return (String)this.getValueInternal(12);
    }

    @Override
    public LookupRow<ID_TYPE> withCssClass(String cssClass) {
        this.setValueInternal(12, StringUtility.intern((String)cssClass));
        return this;
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.getValueInternal(5);
    }

    @Override
    public LookupRow<ID_TYPE> withBackgroundColor(String backgroundColor) {
        this.setValueInternal(5, StringUtility.intern((String)backgroundColor));
        return this;
    }

    @Override
    public FontSpec getFont() {
        String s = (String)this.getValueInternal(7);
        return s != null ? FontSpec.parse(s) : null;
    }

    public LookupRow<ID_TYPE> withFont(String font) {
        return this.withFont(FontSpec.parse(font));
    }

    @Override
    public LookupRow<ID_TYPE> withFont(FontSpec font) {
        this.setValueInternal(7, font != null ? StringUtility.intern((String)font.toPattern()) : null);
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.getOrElse(8, Boolean.TRUE);
    }

    @Override
    public LookupRow<ID_TYPE> withEnabled(boolean enabled) {
        this.setIfNotDefault(8, enabled, Boolean.TRUE);
        return this;
    }

    @Override
    public boolean isActive() {
        return this.getOrElse(10, Boolean.TRUE);
    }

    @Override
    public LookupRow<ID_TYPE> withActive(boolean active) {
        this.setIfNotDefault(10, active, Boolean.TRUE);
        return this;
    }

    @Override
    public AbstractTableRowData getAdditionalTableRowData() {
        return (AbstractTableRowData)this.getValueInternal(11);
    }

    @Override
    public LookupRow<ID_TYPE> withAdditionalTableRowData(AbstractTableRowData bean) {
        this.setValueInternal(11, bean);
        return this;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getKey() + ", " + this.getText() + "]";
    }
}

