/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.shared.http.AbstractMultiSessionCookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class MultiSessionCookieStore
extends AbstractMultiSessionCookieStore<CookieStore>
implements CookieStore {
    private static final Logger LOG = LoggerFactory.getLogger(MultiSessionCookieStore.class);

    @Override
    protected CookieStore createDefaultCookieStore() {
        CookieStore cookieStore = this.createNewCookieStore();
        return new P_DefaultCookieStoreDecorator(cookieStore);
    }

    @Override
    protected CookieStore createNewCookieStore() {
        return new CookieManager().getCookieStore();
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        ((CookieStore)this.getDelegate()).add(uri, cookie);
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        return ((CookieStore)this.getDelegate()).get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return ((CookieStore)this.getDelegate()).getCookies();
    }

    @Override
    public List<URI> getURIs() {
        return ((CookieStore)this.getDelegate()).getURIs();
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        return ((CookieStore)this.getDelegate()).remove(uri, cookie);
    }

    @Override
    public boolean removeAll() {
        return ((CookieStore)this.getDelegate()).removeAll();
    }

    private static class P_DefaultCookieStoreDecorator
    implements CookieStore {
        private final CookieStore m_cookieStore;

        public P_DefaultCookieStoreDecorator(CookieStore cookieStore) {
            this.m_cookieStore = cookieStore;
        }

        @Override
        public void add(URI uri, HttpCookie cookie) {
            Assertions.assertNotNull((Object)cookie);
            Exception e = null;
            if (LOG.isDebugEnabled()) {
                e = new Exception("stack trace for debugging");
            }
            LOG.warn("adding cookie to default cookie store which could be used by other users too [uri={}, cookieName={}]", new Object[]{uri, cookie.getName(), e});
            this.m_cookieStore.add(uri, cookie);
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            return this.m_cookieStore.get(uri);
        }

        @Override
        public List<HttpCookie> getCookies() {
            return this.m_cookieStore.getCookies();
        }

        @Override
        public List<URI> getURIs() {
            return this.m_cookieStore.getURIs();
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            return this.m_cookieStore.remove(uri, cookie);
        }

        @Override
        public boolean removeAll() {
            return this.m_cookieStore.removeAll();
        }
    }
}

