/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.servicetunnel.http.MultiSessionCookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class MultiSessionCookieStoreInstaller {
    private static final Logger LOG = LoggerFactory.getLogger(MultiSessionCookieStoreInstaller.class);
    private CookieHandler m_oldCookieHandler;
    private CookieHandler m_newCookieHandler;

    public void install() {
        CookieHandler cookieHandler = CookieHandler.getDefault();
        if (!this.checkMultiSessionCookieStoreAlreadyInstalled(cookieHandler)) {
            this.m_oldCookieHandler = cookieHandler;
            this.m_newCookieHandler = new CookieManager((CookieStore)BEANS.get(MultiSessionCookieStore.class), CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(this.m_newCookieHandler);
            LOG.info("Successfully installed {}", (Object)this.cookieHandlerToString(this.m_newCookieHandler));
        }
    }

    protected boolean checkMultiSessionCookieStoreAlreadyInstalled(CookieHandler cookieHandler) {
        if (cookieHandler != null) {
            if (cookieHandler instanceof CookieManager) {
                CookieStore cookieStore = ((CookieManager)cookieHandler).getCookieStore();
                if (cookieStore != null && cookieStore.getClass() == Platform.get().getBeanManager().getBean(MultiSessionCookieStore.class).getBeanClazz()) {
                    LOG.info("Don't overriding already installed MultiSessionCookieStore cookie handler from same deployment: {}", (Object)this.cookieHandlerToString(cookieHandler));
                    return true;
                }
                if (cookieStore != null && StringUtility.containsStringIgnoreCase((String)cookieStore.getClass().getSimpleName(), (String)MultiSessionCookieStore.class.getSimpleName())) {
                    throw new PlatformException("Instance of MultiSessionCookieStore already installed by another deployment. Only one Scout application using servlet tunnel is supported within one application server!", new Object[0]);
                }
            }
            LOG.warn("Overriding pre-installed cookie handler: {}", (Object)this.cookieHandlerToString(cookieHandler));
        }
        return false;
    }

    public void uninstall() {
        if (this.m_newCookieHandler != null) {
            if (CookieHandler.getDefault() == this.m_newCookieHandler) {
                CookieHandler.setDefault(this.m_oldCookieHandler);
                LOG.info("Successfully uninstalled {}", (Object)this.cookieHandlerToString(this.m_newCookieHandler));
            } else {
                LOG.warn("Could not uninstall {}, because it was apparently replaced with {}", (Object)this.cookieHandlerToString(this.m_newCookieHandler), (Object)this.cookieHandlerToString(CookieHandler.getDefault()));
            }
            this.m_newCookieHandler = null;
        }
    }

    protected String cookieHandlerToString(CookieHandler cookieHandler) {
        if (cookieHandler == null) {
            return "null";
        }
        String s = cookieHandler.toString();
        if (cookieHandler instanceof CookieManager) {
            CookieStore cookieStore = ((CookieManager)cookieHandler).getCookieStore();
            s = String.valueOf(s) + " (Cookie store: " + (cookieStore == null ? "null" : cookieStore.toString()) + ")";
        }
        return s;
    }
}

