/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.session;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentMap<String, Object> m_dataMap = new ConcurrentHashMap<String, Object>();

    public void set(String key, Object value) {
        Assertions.assertNotNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        if (value == null) {
            this.m_dataMap.remove(key);
        } else {
            this.m_dataMap.put(key, value);
        }
    }

    public Object computeIfAbsent(String key, Callable<?> producer) {
        Object newValue;
        Assertions.assertNotNull(producer, (String)"producer must not be null", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        Object existingValue = this.m_dataMap.get(key);
        if (existingValue != null) {
            return existingValue;
        }
        try {
            newValue = producer.call();
        }
        catch (Exception e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e);
        }
        if (newValue == null) {
            return null;
        }
        existingValue = this.m_dataMap.putIfAbsent(key, newValue);
        if (existingValue != null) {
            return existingValue;
        }
        return newValue;
    }

    public Object get(String key) {
        Assertions.assertNotNull((Object)key, (String)"key must not be null", (Object[])new Object[0]);
        return this.m_dataMap.get(key);
    }
}

