/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ui.webresource.IWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.ScriptResourceIndexes;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;

public abstract class AbstractWebResourceResolver
implements IWebResourceResolver {
    public static final String OUTPUT_FOLDER_NAME = "dist";
    public static final String DEV_FOLDER_NAME = "dev";
    public static final String MIN_FOLDER_NAME = "prod";
    public static final String WEB_RESOURCE_FOLDER_NAME = "res";

    public static String stripLeadingSlash(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    @Override
    public List<WebResourceDescriptor> resolveScriptResource(String path, boolean minified, String theme) {
        if (path == null) {
            return Collections.emptyList();
        }
        String subFolder = this.getScriptResourceFolder(minified);
        String themePath = this.getThemePath(path, theme);
        List<WebResourceDescriptor> themeResource = this.lookupResource(path, themePath, subFolder, minified);
        if (CollectionUtility.hasElements(themeResource) || Objects.equals(path, themePath)) {
            return themeResource;
        }
        return this.lookupResource(path, path, subFolder, minified);
    }

    @Override
    public List<WebResourceDescriptor> resolveWebResource(String path, boolean minified) {
        if (path == null) {
            return Collections.emptyList();
        }
        return this.lookupResource(path, path, WEB_RESOURCE_FOLDER_NAME, minified);
    }

    protected String getScriptResourceFolder(boolean minified) {
        return minified ? MIN_FOLDER_NAME : DEV_FOLDER_NAME;
    }

    protected List<WebResourceDescriptor> lookupResource(String requestedPath, String path, String subFolder, boolean minified) {
        String[] stringArray = new String[3];
        stringArray[2] = path;
        String[] lookupList = stringArray;
        if (minified) {
            String pathFromIndex = ScriptResourceIndexes.getMinifiedPath(path);
            if (Objects.equals(path, pathFromIndex)) {
                String minifiedPath = this.getMinifiedPath(path);
                if (!Objects.equals(path, minifiedPath)) {
                    lookupList[1] = minifiedPath;
                }
            } else {
                lookupList[0] = pathFromIndex;
            }
        }
        String[] stringArray2 = lookupList;
        int n = lookupList.length;
        int n2 = 0;
        while (n2 < n) {
            List<WebResourceDescriptor> resources;
            Stream<URL> resourceStream;
            String lookupPath = stringArray2[n2];
            if (lookupPath != null && (resourceStream = this.getResourceImpl(String.valueOf(subFolder) + '/' + AbstractWebResourceResolver.stripLeadingSlash(lookupPath))) != null && CollectionUtility.hasElements(resources = resourceStream.map(url -> new WebResourceDescriptor((URL)url, requestedPath, lookupPath)).collect(Collectors.toList()))) {
                return resources;
            }
            ++n2;
        }
        return Collections.emptyList();
    }

    protected String getMinifiedPath(String path) {
        String[] parts = FileUtility.getFilenameParts((String)path);
        if (parts == null || parts[1] == null) {
            return path;
        }
        return String.valueOf(parts[0]) + ".min." + parts[1];
    }

    protected String getThemePath(String path, String theme) {
        if (!StringUtility.hasText((CharSequence)theme)) {
            return path;
        }
        String[] parts = FileUtility.getFilenameParts((String)path);
        if (parts == null || !"css".equals(parts[1])) {
            return path;
        }
        return String.valueOf(parts[0]) + '-' + theme + ".css";
    }

    protected abstract Stream<URL> getResourceImpl(String var1);
}

