/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.io.IOException;
import java.net.URL;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.EnumerationUtility;
import org.eclipse.scout.rt.shared.ui.webresource.AbstractWebResourceResolver;

public class ClasspathWebResourceResolver
extends AbstractWebResourceResolver {
    private final ClassLoader m_classLoader = this.getClass().getClassLoader();

    @Override
    protected Stream<URL> getResourceImpl(String resourcePath) {
        try {
            return EnumerationUtility.asStream(this.m_classLoader.getResources(resourcePath));
        }
        catch (IOException e) {
            throw new PlatformException("Error getting resources for path '{}' from classpath.", new Object[]{resourcePath, e});
        }
    }
}

