/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ui.webresource.ScriptRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class FileListParser {
    private static final Logger LOG = LoggerFactory.getLogger(FileListParser.class);
    public static final String DEFAULT_ENTRY_POINT_DELIMITER = "~";

    public Stream<FileListEntry> parse(URL url) {
        return this.readAllLinesFromUrl(url).map(this::getFileListEntryFor).filter(Optional::isPresent).map(Optional::get);
    }

    protected Optional<FileListEntry> getFileListEntryFor(String line) {
        return Optional.ofNullable(line).filter(StringUtility::hasText).map(String::trim).flatMap(this::parse);
    }

    protected String getEntryPointDelimiter() {
        return DEFAULT_ENTRY_POINT_DELIMITER;
    }

    protected Optional<FileListEntry> parse(String rawLine) {
        Optional<ScriptRequest> result;
        String path = rawLine;
        if (path.indexOf(47) < 0) {
            path = "./" + path;
        }
        if (!(result = ScriptRequest.tryParse(path)).isPresent()) {
            LOG.debug("Entry in script resource index ignored: '{}'.", (Object)rawLine);
            return Optional.empty();
        }
        ScriptRequest scriptRequest = result.get();
        StringTokenizer tokenizer = new StringTokenizer(scriptRequest.baseName(), this.getEntryPointDelimiter());
        HashSet<String> entryPoints = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String entryPoint = tokenizer.nextToken();
            if (!StringUtility.hasText((CharSequence)entryPoint)) continue;
            entryPoints.add(entryPoint);
        }
        if (entryPoints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new FileListEntry(scriptRequest, rawLine, entryPoints));
    }

    protected Stream<String> readAllLinesFromUrl(URL url) {
        try {
            return IOUtility.readAllLinesFromUrl((URL)url, (Charset)StandardCharsets.UTF_8).stream();
        }
        catch (IOException e) {
            throw new PlatformException("Unable to read from URL '{}'.", new Object[]{url, e});
        }
    }

    public static class FileListEntry {
        private final ScriptRequest m_asset;
        private final String m_rawLine;
        private final Set<String> m_entryPoints;

        public FileListEntry(ScriptRequest asset, String rawLine, Set<String> entryPoints) {
            this.m_asset = asset;
            this.m_rawLine = rawLine;
            this.m_entryPoints = new HashSet<String>(entryPoints);
        }

        public Set<String> entryPoints() {
            return Collections.unmodifiableSet(this.m_entryPoints);
        }

        public String rawLine() {
            return this.m_rawLine;
        }

        public ScriptRequest asset() {
            return this.m_asset;
        }

        public String toString() {
            return this.m_rawLine;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileListEntry that = (FileListEntry)o;
            return this.m_rawLine.equals(that.m_rawLine);
        }

        public int hashCode() {
            return Objects.hash(this.m_rawLine);
        }
    }
}

