/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.ui.webresource.ClasspathWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.FilesystemWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.IWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;

@Bean
public class WebResources {
    private static final LazyValue<WebResources> WEB_RESOURCES = new LazyValue(WebResources.class);
    private static final LazyValue<FilesystemWebResourceResolver> FS_RESOLVER = new LazyValue(FilesystemWebResourceResolver.class);
    private static final LazyValue<ClasspathWebResourceResolver> CP_RESOLVER = new LazyValue(ClasspathWebResourceResolver.class);

    public static Optional<WebResourceDescriptor> resolveScriptResource(String path, boolean minified, String theme) {
        return WebResources.resolveScriptResources(path, minified, theme).stream().findFirst();
    }

    public static List<WebResourceDescriptor> resolveScriptResources(String path, boolean minified, String theme) {
        return ((WebResources)WEB_RESOURCES.get()).resolveScriptResourceInternal(path, minified, theme);
    }

    public static Optional<WebResourceDescriptor> resolveWebResource(String path, boolean minified) {
        return WebResources.resolveWebResources(path, minified).stream().findFirst();
    }

    public static List<WebResourceDescriptor> resolveWebResources(String path, boolean minified) {
        return ((WebResources)WEB_RESOURCES.get()).resolveWebResourceInternal(path, minified);
    }

    protected List<WebResourceDescriptor> resolveScriptResourceInternal(String path, boolean minified, String theme) {
        return this.resolveResource(resolver -> resolver.resolveScriptResource(this.cleanPath(path), minified, theme));
    }

    protected List<WebResourceDescriptor> resolveWebResourceInternal(String path, boolean minified) {
        return this.resolveResource(resolver -> resolver.resolveWebResource(this.cleanPath(path), minified));
    }

    protected List<WebResourceDescriptor> resolveResource(Function<IWebResourceResolver, List<WebResourceDescriptor>> callFunc) {
        ArrayList resFromFilesystem;
        if (((Boolean)CONFIG.getPropertyValue(SharedConfigProperties.LoadWebResourcesFromFilesystemConfigProperty.class)).booleanValue() && CollectionUtility.hasElements((Collection)(resFromFilesystem = CollectionUtility.arrayListWithoutNullElements((Collection)callFunc.apply((IWebResourceResolver)FS_RESOLVER.get()))))) {
            return resFromFilesystem;
        }
        return CollectionUtility.arrayListWithoutNullElements((Collection)callFunc.apply((IWebResourceResolver)CP_RESOLVER.get()));
    }

    protected String cleanPath(String path) {
        if (!StringUtility.hasText((CharSequence)path)) {
            return null;
        }
        return path.trim();
    }
}

