/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.pomless;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractXMLTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.w3c.dom.Element;

@Component(role=Mapping.class, hint="eclipse-feature")
public class TychoFeatureMapping
extends AbstractXMLTychoMapping {
    private static final String NAME_PREFIX = "[feature] ";
    private static final String FEATURE_XML = "feature.xml";
    public static final String PACKAGING = "eclipse-feature";

    @Override
    protected String getPackaging() {
        return PACKAGING;
    }

    @Override
    public float getPriority() {
        return 30.0f;
    }

    @Override
    protected void initModelFromXML(Model model, Element xml, Path artifactFile) throws IOException {
        model.setArtifactId(TychoFeatureMapping.getRequiredXMLAttributeValue(xml, "id"));
        model.setVersion(this.getPomVersion(TychoFeatureMapping.getRequiredXMLAttributeValue(xml, "version"), model, artifactFile));
        Path featureProperties = artifactFile.getParent().resolve("feature.properties");
        Supplier<Properties> properties = TychoFeatureMapping.getPropertiesSupplier(featureProperties);
        String label = TychoFeatureMapping.localizedValue(TychoFeatureMapping.getXMLAttributeValue(xml, "label"), properties);
        model.setName(NAME_PREFIX + (label != null ? label : model.getArtifactId()));
        String provider = TychoFeatureMapping.localizedValue(TychoFeatureMapping.getXMLAttributeValue(xml, "provider-name"), properties);
        if (provider != null) {
            Organization organization = new Organization();
            organization.setName(provider);
            model.setOrganization(organization);
        }
    }

    @Override
    protected boolean isValidLocation(Path location) {
        return TychoFeatureMapping.getFileName(location).equals(FEATURE_XML);
    }

    @Override
    protected File getPrimaryArtifact(File dir) {
        File featureXml = new File(dir, FEATURE_XML);
        if (featureXml.exists()) {
            return featureXml;
        }
        return null;
    }
}

