/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.p2.resolver.ClassifiedLocation;
import org.eclipse.tycho.p2.resolver.DefaultP2ResolutionResultEntry;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;

public class DefaultP2ResolutionResult
implements P2ResolutionResult {
    private final Map<ClassifiedLocation, P2ResolutionResult.Entry> entries = new LinkedHashMap<ClassifiedLocation, P2ResolutionResult.Entry>();
    private final Set<Object> nonReactorUnits = new LinkedHashSet<Object>();

    public Collection<P2ResolutionResult.Entry> getArtifacts() {
        return this.entries.values();
    }

    public void addArtifact(String type, String id, String version, File location, String classifier, IInstallableUnit installableUnit) {
        ClassifiedLocation key = new ClassifiedLocation(location, classifier);
        DefaultP2ResolutionResultEntry entry = (DefaultP2ResolutionResultEntry)this.entries.get(key);
        if (entry == null) {
            entry = new DefaultP2ResolutionResultEntry(type, id, version, location, classifier);
            this.entries.put(key, entry);
        } else if (type != null) {
            if (!("eclipse-product".equals(entry.getType()) && "eclipse-product".equals(type) || entry.getType() == null || classifier != null || type.equals(entry.getType()) && id.equals(entry.getId()) && version.equals(entry.getVersion()))) {
                throw new RuntimeException("Ambiguous main artifact of the project at " + location + ". Make sure that additional units added via p2.inf specify a 'maven-classifier' property.");
            }
            entry.setType(type);
            entry.setId(id);
            entry.setVersion(version);
        }
        entry.addInstallableUnit(installableUnit);
    }

    public void removeEntriesWithUnknownType() {
        Iterator<Map.Entry<ClassifiedLocation, P2ResolutionResult.Entry>> iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue().getType() != null) continue;
            iterator.remove();
        }
    }

    public void addNonReactorUnit(Object installableUnit) {
        this.nonReactorUnits.add(installableUnit);
    }

    public void addNonReactorUnits(Set<?> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }

    public Set<?> getNonReactorUnits() {
        return this.nonReactorUnits;
    }

    protected static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }
}

