/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.util.resolution;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.util.resolution.ResolutionData;
import org.eclipse.tycho.p2.util.resolution.ResolverException;

public abstract class AbstractResolutionStrategy {
    protected static final IInstallableUnit[] EMPTY_IU_ARRAY = new IInstallableUnit[0];
    protected final MavenLogger logger;
    protected ResolutionData data;

    protected AbstractResolutionStrategy(MavenLogger logger) {
        this.logger = logger;
    }

    public final void setData(ResolutionData data) {
        this.data = data;
    }

    public final Collection<IInstallableUnit> resolve(TargetEnvironment environment, IProgressMonitor monitor) throws ResolverException {
        return this.resolve(this.getEffectiveFilterProperties(environment), monitor);
    }

    public Collection<IInstallableUnit> multiPlatformResolve(List<TargetEnvironment> environments, IProgressMonitor monitor) throws ResolverException {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        for (TargetEnvironment environment : environments) {
            result.addAll(this.resolve(this.getEffectiveFilterProperties(environment), monitor));
        }
        return result;
    }

    protected abstract Collection<IInstallableUnit> resolve(Map<String, String> var1, IProgressMonitor var2) throws ResolverException;

    private Map<String, String> getEffectiveFilterProperties(TargetEnvironment environment) {
        HashMap result = environment.toFilterProperties();
        result.put("org.eclipse.update.install.features", "true");
        this.insertAdditionalFilterProperties(result);
        return result;
    }

    private void insertAdditionalFilterProperties(Map<String, String> result) {
        for (Map.Entry<String, String> entry : this.data.getAdditionalFilterProperties().entrySet()) {
            String overwrittenValue = result.put(entry.getKey(), entry.getValue());
            if (overwrittenValue == null) continue;
            this.logger.warn("Overriding profile property '" + entry.getKey() + "' with value '" + entry.getValue() + "' (was '" + overwrittenValue + "')");
        }
    }
}

