/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.failsafe.util.FailsafeSummaryXmlUtils;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.extensions.ForkNodeFactory;

@Mojo(name="integration-test", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.INTEGRATION_TEST, threadSafe=true)
public class IntegrationTestMojo
extends AbstractSurefireMojo {
    private static final String FAILSAFE_IN_PROGRESS_CONTEXT_KEY = "failsafe-in-progress";
    @Parameter
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    private File defaultClassesDirectory;
    @Parameter(property="skipITs")
    private boolean skipITs;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports")
    private File reportsDirectory;
    @Parameter(property="it.test")
    private String test;
    @Parameter(defaultValue="${project.build.directory}/failsafe-reports/failsafe-summary.xml", required=true)
    private File summaryFile;
    @Parameter(property="failsafe.printSummary", defaultValue="true")
    private boolean printSummary;
    @Parameter(property="failsafe.reportFormat", defaultValue="brief")
    private String reportFormat;
    @Parameter(property="failsafe.useFile", defaultValue="true")
    private boolean useFile;
    @Deprecated
    @Parameter(property="it.failIfNoSpecifiedTests", defaultValue="true")
    private boolean failIfNoSpecifiedTestsDeprecated;
    @Parameter(property="failsafe.failIfNoSpecifiedTests", defaultValue="true")
    private boolean failIfNoSpecifiedTests;
    @Parameter(property="maven.failsafe.debug")
    private String debugForkedProcess;
    @Parameter(property="failsafe.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter(property="failsafe.exitTimeout", defaultValue="30")
    private int forkedProcessExitTimeoutInSeconds;
    @Parameter(property="failsafe.parallel.timeout")
    private double parallelTestsTimeoutInSeconds;
    @Parameter(property="failsafe.parallel.forcedTimeout")
    private double parallelTestsTimeoutForcedInSeconds;
    @Parameter(property="failsafe.includes")
    private List<String> includes;
    @Parameter(property="failsafe.excludes")
    private List<String> excludes;
    @Parameter(property="failsafe.useSystemClassLoader", defaultValue="true")
    private boolean useSystemClassLoader;
    @Parameter(property="failsafe.useManifestOnlyJar", defaultValue="true")
    private boolean useManifestOnlyJar;
    @Parameter(property="encoding", defaultValue="${project.reporting.outputEncoding}")
    private String encoding;
    @Parameter(property="failsafe.rerunFailingTestsCount", defaultValue="0")
    private int rerunFailingTestsCount;
    @Parameter(property="failsafe.suiteXmlFiles")
    private File[] suiteXmlFiles;
    @Parameter(property="failsafe.runOrder", defaultValue="filesystem")
    private String runOrder;
    @Parameter(property="failsafe.runOrder.random.seed")
    private Long runOrderRandomSeed;
    @Parameter(property="failsafe.includesFile")
    private File includesFile;
    @Parameter(property="failsafe.excludesFile")
    private File excludesFile;
    @Parameter(property="failsafe.skipAfterFailureCount", defaultValue="0")
    private int skipAfterFailureCount;
    @Parameter(property="failsafe.shutdown", defaultValue="exit")
    private String shutdown;
    @Parameter(property="failsafe.useModulePath", defaultValue="true")
    private boolean useModulePath;
    @Parameter(property="failsafe.forkNode")
    private ForkNodeFactory forkNode;
    @Parameter(property="failsafe.excludedEnvironmentVariables")
    private String[] excludedEnvironmentVariables;
    @Parameter(property="failsafe.enableProcessChecker")
    private String enableProcessChecker;
    @Parameter(property="failsafe.systemPropertiesFile")
    private File systemPropertiesFile;
    @Parameter(property="failsafe.includeJUnit5Engines")
    private String[] includeJUnit5Engines;
    @Parameter(property="failsafe.excludeJUnit5Engines")
    private String[] excludeJUnit5Engines;

    @Override
    protected int getRerunFailingTestsCount() {
        return this.rerunFailingTestsCount;
    }

    @Override
    protected void handleSummary(RunResult summary, Exception firstForkException) throws MojoExecutionException, MojoFailureException {
        try {
            if (!summary.isNoTestsRun()) {
                Object token = this.getPluginContext().get(FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
                FailsafeSummaryXmlUtils.writeSummary(summary, this.getSummaryFile(), token != null);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        this.getPluginContext().put(FAILSAFE_IN_PROGRESS_CONTEXT_KEY, FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
    }

    private boolean isJarArtifact(File artifactFile) {
        return artifactFile != null && artifactFile.isFile() && artifactFile.getName().toLowerCase().endsWith(".jar");
    }

    private static File toAbsoluteCanonical(File f) {
        try {
            return f == null ? null : f.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected boolean isSkipExecution() {
        return this.isSkip() || this.isSkipTests() || this.isSkipITs() || this.isSkipExec();
    }

    @Override
    protected String getPluginName() {
        return "failsafe";
    }

    @Override
    protected String[] getDefaultIncludes() {
        return new String[]{"**/IT*.java", "**/*IT.java", "**/*ITCase.java"};
    }

    @Override
    protected String getReportSchemaLocation() {
        return "https://maven.apache.org/surefire/maven-failsafe-plugin/xsd/failsafe-test-report.xsd";
    }

    @Override
    public boolean isSkipTests() {
        return this.skipTests;
    }

    @Override
    @Deprecated
    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    @Override
    @Deprecated
    public boolean isSkipExec() {
        return this.skipExec;
    }

    @Override
    @Deprecated
    public void setSkipExec(boolean skipExec) {
        this.skipExec = skipExec;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Override
    public File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    @Override
    public void setTestClassesDirectory(File testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    @Override
    public File getMainBuildPath() {
        boolean isDefaultClsDir;
        File artifact = this.getProject().getArtifact().getFile();
        boolean bl = isDefaultClsDir = this.classesDirectory == null;
        return isDefaultClsDir ? (this.isJarArtifact(artifact) ? artifact : this.defaultClassesDirectory) : this.classesDirectory;
    }

    @Override
    public void setMainBuildPath(File mainBuildPath) {
        this.classesDirectory = IntegrationTestMojo.toAbsoluteCanonical(mainBuildPath);
    }

    public void setDefaultClassesDirectory(File defaultClassesDirectory) {
        this.defaultClassesDirectory = IntegrationTestMojo.toAbsoluteCanonical(defaultClassesDirectory);
    }

    @Override
    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    @Override
    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    @Override
    public String getTest() {
        return this.test;
    }

    @Override
    public void setTest(String test) {
        this.test = test;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    @Override
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    @Override
    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    @Override
    public String getReportFormat() {
        return this.reportFormat;
    }

    @Override
    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Override
    public boolean isUseFile() {
        return this.useFile;
    }

    @Override
    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    @Override
    public String getDebugForkedProcess() {
        return this.debugForkedProcess;
    }

    @Override
    public void setDebugForkedProcess(String debugForkedProcess) {
        this.debugForkedProcess = debugForkedProcess;
    }

    @Override
    public int getForkedProcessTimeoutInSeconds() {
        return this.forkedProcessTimeoutInSeconds;
    }

    @Override
    public void setForkedProcessTimeoutInSeconds(int forkedProcessTimeoutInSeconds) {
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
    }

    @Override
    public int getForkedProcessExitTimeoutInSeconds() {
        return this.forkedProcessExitTimeoutInSeconds;
    }

    @Override
    public void setForkedProcessExitTimeoutInSeconds(int forkedProcessExitTimeoutInSeconds) {
        this.forkedProcessExitTimeoutInSeconds = forkedProcessExitTimeoutInSeconds;
    }

    @Override
    public double getParallelTestsTimeoutInSeconds() {
        return this.parallelTestsTimeoutInSeconds;
    }

    @Override
    public void setParallelTestsTimeoutInSeconds(double parallelTestsTimeoutInSeconds) {
        this.parallelTestsTimeoutInSeconds = parallelTestsTimeoutInSeconds;
    }

    @Override
    public double getParallelTestsTimeoutForcedInSeconds() {
        return this.parallelTestsTimeoutForcedInSeconds;
    }

    @Override
    public void setParallelTestsTimeoutForcedInSeconds(double parallelTestsTimeoutForcedInSeconds) {
        this.parallelTestsTimeoutForcedInSeconds = parallelTestsTimeoutForcedInSeconds;
    }

    @Override
    public boolean isUseSystemClassLoader() {
        return this.useSystemClassLoader;
    }

    @Override
    public void setUseSystemClassLoader(boolean useSystemClassLoader) {
        this.useSystemClassLoader = useSystemClassLoader;
    }

    @Override
    public boolean isUseManifestOnlyJar() {
        return this.useManifestOnlyJar;
    }

    @Override
    public void setUseManifestOnlyJar(boolean useManifestOnlyJar) {
        this.useManifestOnlyJar = useManifestOnlyJar;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isTestFailureIgnore() {
        return true;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
    }

    @Override
    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
        checksum.add(this.skipITs);
        checksum.add(this.summaryFile);
    }

    @Override
    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    @Override
    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    @Override
    public boolean getFailIfNoSpecifiedTests() {
        if (!this.failIfNoSpecifiedTestsDeprecated) {
            this.getConsoleLogger().warning("Use " + this.getPluginName() + ".failIfNoSpecifiedTests property instead of obsolete it.failIfNoSpecifiedTests.");
        }
        return this.failIfNoSpecifiedTests && this.failIfNoSpecifiedTestsDeprecated;
    }

    @Override
    public void setFailIfNoSpecifiedTests(boolean failIfNoSpecifiedTests) {
        this.failIfNoSpecifiedTests = failIfNoSpecifiedTests;
    }

    @Override
    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    @Override
    public String getShutdown() {
        return this.shutdown;
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public File[] getSuiteXmlFiles() {
        return (File[])this.suiteXmlFiles.clone();
    }

    @Override
    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = (File[])suiteXmlFiles.clone();
    }

    @Override
    public String getRunOrder() {
        return this.runOrder;
    }

    @Override
    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    @Override
    public Long getRunOrderRandomSeed() {
        return this.runOrderRandomSeed;
    }

    @Override
    public void setRunOrderRandomSeed(Long runOrderRandomSeed) {
        this.runOrderRandomSeed = runOrderRandomSeed;
    }

    @Override
    public File getIncludesFile() {
        return this.includesFile;
    }

    @Override
    public File getExcludesFile() {
        return this.excludesFile;
    }

    @Override
    protected boolean useModulePath() {
        return this.useModulePath;
    }

    @Override
    protected void setUseModulePath(boolean useModulePath) {
        this.useModulePath = useModulePath;
    }

    @Override
    protected final List<File> suiteXmlFiles() {
        return this.hasSuiteXmlFiles() ? Arrays.asList(this.suiteXmlFiles) : Collections.emptyList();
    }

    @Override
    protected final boolean hasSuiteXmlFiles() {
        return this.suiteXmlFiles != null && this.suiteXmlFiles.length != 0;
    }

    @Override
    protected final ForkNodeFactory getForkNode() {
        return this.forkNode;
    }

    @Override
    protected final String[] getExcludedEnvironmentVariables() {
        return this.excludedEnvironmentVariables == null ? new String[]{} : this.excludedEnvironmentVariables;
    }

    void setExcludedEnvironmentVariables(String[] excludedEnvironmentVariables) {
        this.excludedEnvironmentVariables = excludedEnvironmentVariables;
    }

    @Override
    protected final String getEnableProcessChecker() {
        return this.enableProcessChecker;
    }

    @Override
    public String[] getIncludeJUnit5Engines() {
        return this.includeJUnit5Engines;
    }

    @Override
    public void setIncludeJUnit5Engines(String[] includeJUnit5Engines) {
        this.includeJUnit5Engines = includeJUnit5Engines;
    }

    @Override
    public String[] getExcludeJUnit5Engines() {
        return this.excludeJUnit5Engines;
    }

    @Override
    public void setExcludeJUnit5Engines(String[] excludeJUnit5Engines) {
        this.excludeJUnit5Engines = excludeJUnit5Engines;
    }
}

