/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import org.apache.maven.surefire.shared.utils.StringUtils;

public enum ProcessCheckerType {
    PING("ping"),
    NATIVE("native"),
    ALL("all");

    private final String type;

    private ProcessCheckerType(String type) {
        this.type = type;
    }

    public static ProcessCheckerType toEnum(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        for (ProcessCheckerType e : ProcessCheckerType.values()) {
            if (!e.type.equals(type)) continue;
            return e;
        }
        throw new IllegalArgumentException("unknown process checker");
    }

    public String getType() {
        return this.type;
    }

    public static boolean isValid(String type) {
        try {
            ProcessCheckerType.toEnum(type);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

