/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

class BundleClassLoader
extends ClassLoader {
    private Collection<Bundle> bundles;
    private boolean debug;

    public BundleClassLoader(List<Bundle> bundles, boolean debug) {
        this.bundles = new LinkedHashSet<Bundle>(bundles);
        this.debug = debug;
        for (Bundle bundle : bundles) {
            Objects.requireNonNull(bundle, "Bundle can't be null");
            BundleWiring wiring = Objects.requireNonNull((BundleWiring)bundle.adapt(BundleWiring.class), "Bundle needs to have a wiring, is it not resolved?");
            if (debug) {
                System.out.println("Bundle " + bundle + " is wired to:");
            }
            for (BundleWire wired : wiring.getRequiredWires(null)) {
                Bundle provider = wired.getProvider().getBundle();
                if (!this.bundles.add(provider) || !debug) continue;
                System.out.println("  - " + provider.getSymbolicName() + " (" + provider.getVersion() + ")");
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (Bundle bundle : this.bundles) {
            try {
                return bundle.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        String message = name + " was not found in " + this.toString();
        if (this.debug) {
            System.out.println(message);
        }
        throw new ClassNotFoundException(message);
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle bundle : this.bundles) {
            URL resource = bundle.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        if (this.debug) {
            System.out.println("RESOURCE " + name + " was not found in " + this.toString());
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Bundle bundle : this.bundles) {
            Enumeration resources = bundle.getResources(name);
            if (resources == null) continue;
            while (resources.hasMoreElements()) {
                URL url = (URL)resources.nextElement();
                result.add(url);
            }
        }
        if (this.debug && result.isEmpty()) {
            System.out.println("RESOURCES " + name + " where not found in " + this.toString());
        }
        return Collections.enumeration(result);
    }

    public String toString() {
        return this.bundles.stream().map(b -> b.getSymbolicName() + " [" + b.getVersion() + "]").collect(Collectors.joining(" or "));
    }
}

